/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.auth.impl;

import java.util.Collection;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.IdentityProviderFactory;
import org.kie.kogito.auth.IdentityProviders;
import org.kie.kogito.auth.impl.KogitoAuthConfig;

public class IdentityProviderFactoryImpl
implements IdentityProviderFactory {
    private final IdentityProvider identityProvider;
    private final KogitoAuthConfig config;

    public IdentityProviderFactoryImpl(IdentityProvider identityProvider, KogitoAuthConfig config) {
        this.identityProvider = identityProvider;
        this.config = config;
    }

    @Override
    public IdentityProvider getOrImpersonateIdentity(String user, Collection<String> roles) {
        if (!this.config.isEnabled()) {
            return IdentityProviders.of(user, roles);
        }
        Collection<String> identityRoles = this.identityProvider.getRoles();
        if (this.config.getRolesThatAllowImpersonation().stream().anyMatch(identityRoles::contains)) {
            return IdentityProviders.of(user, roles);
        }
        return this.identityProvider;
    }
}

