/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.internal.process.workitem;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.kie.kogito.internal.process.workitem.KogitoWorkItem;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemManager;
import org.kie.kogito.internal.process.workitem.Policy;
import org.kie.kogito.internal.process.workitem.WorkItemLifeCyclePhase;
import org.kie.kogito.internal.process.workitem.WorkItemTransition;

public interface WorkItemLifeCycle {
    default public List<WorkItemLifeCyclePhase> phaseByStatus(String phaseStatus) {
        return this.phases().stream().filter(e -> Objects.equals(e.sourceStatus().getName(), phaseStatus)).toList();
    }

    default public WorkItemLifeCyclePhase phaseById(String phaseId, String phaseStatus) {
        return this.phases().stream().filter(e -> Objects.equals(e.id(), phaseId) && Objects.equals(e.sourceStatus().getName(), phaseStatus)).findAny().orElse(null);
    }

    public Collection<WorkItemLifeCyclePhase> phases();

    public Optional<WorkItemTransition> transitionTo(KogitoWorkItemManager var1, KogitoWorkItemHandler var2, KogitoWorkItem var3, WorkItemTransition var4);

    default public Set<WorkItemLifeCyclePhase> allowedPhases(String phaseStatus) {
        return this.phaseByStatus(phaseStatus).stream().collect(Collectors.toSet());
    }

    public WorkItemTransition newTransition(String var1, String var2, Map<String, Object> var3, Policy ... var4);
}

