/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.descriptors;

import java.util.Map;
import java.util.UUID;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.descriptors.ProcessInstanceJobDescription;
import org.kie.kogito.jobs.descriptors.UserTaskInstanceJobDescription;

public class UserTaskInstanceJobDescriptionBuilder {
    private String id;
    private ExpirationTime expirationTime;
    private Integer priority = ProcessInstanceJobDescription.DEFAULT_PRIORITY;
    private String userTaskInstanceId;
    private Map<String, Object> metadata;

    public UserTaskInstanceJobDescriptionBuilder id(String id) {
        this.id = id;
        return this;
    }

    public UserTaskInstanceJobDescriptionBuilder generateId() {
        return this.id(UUID.randomUUID().toString());
    }

    public UserTaskInstanceJobDescriptionBuilder expirationTime(ExpirationTime expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    public UserTaskInstanceJobDescriptionBuilder priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public UserTaskInstanceJobDescriptionBuilder userTaskInstanceId(String userTaskInstanceId) {
        this.userTaskInstanceId = userTaskInstanceId;
        return this;
    }

    public UserTaskInstanceJobDescriptionBuilder metadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    public UserTaskInstanceJobDescription build() {
        return new UserTaskInstanceJobDescription(this.id, this.expirationTime, this.priority, this.userTaskInstanceId, (String)this.metadata.get("ProcessId"), (String)this.metadata.get("ProcessInstanceId"), (String)this.metadata.get("NodeInstanceId"), (String)this.metadata.get("RootProcessInstanceId"), (String)this.metadata.get("RootProcessId"));
    }
}

