/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process;

import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessInstance;

public class ProcessInstanceExecutionException
extends RuntimeException {
    private static final long serialVersionUID = 8031225233775014572L;
    private final String processInstanceId;
    private final String failedNodeId;
    private final String failedNodeInstanceId;
    private final String errorMessage;

    public ProcessInstanceExecutionException(String processInstanceId, String failedNodeId, String failedNodeInstanceId, String errorMessage) {
        this(processInstanceId, failedNodeId, failedNodeInstanceId, errorMessage, null);
    }

    public ProcessInstanceExecutionException(String processInstanceId, String failedNodeId, String failedNodeInstanceId, String errorMessage, Throwable rootCause) {
        super("Process instance with id " + processInstanceId + " failed because of " + errorMessage, rootCause);
        this.processInstanceId = processInstanceId;
        this.failedNodeId = failedNodeId;
        this.failedNodeInstanceId = failedNodeInstanceId;
        this.errorMessage = errorMessage;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getFailedNodeId() {
        return this.failedNodeId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getFailedNodeInstanceId() {
        return this.failedNodeInstanceId;
    }

    public static ProcessInstanceExecutionException fromError(ProcessInstance<?> processInstance) {
        ProcessError error = processInstance.error().get();
        return new ProcessInstanceExecutionException(processInstance.id(), error.failedNodeId(), error.failedNodeInstanceId(), error.errorMessage(), error.errorCause());
    }
}

