/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.usertask.lifecycle;

import java.util.Objects;

public class UserTaskState {
    private TerminationType terminate;
    private String name;

    public static UserTaskState of(String name) {
        return UserTaskState.of(name, null);
    }

    public static UserTaskState of(String name, TerminationType terminate) {
        return new UserTaskState(name, terminate);
    }

    public UserTaskState() {
    }

    public TerminationType getTerminate() {
        return this.terminate;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTerminate(TerminationType terminate) {
        this.terminate = terminate;
    }

    private UserTaskState(String name, TerminationType terminate) {
        this.name = name;
        this.terminate = terminate;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTerminate() {
        return this.terminate != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.terminate});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserTaskState other = (UserTaskState)obj;
        return Objects.equals(this.name, other.name) && this.terminate == other.terminate;
    }

    public static UserTaskState initalized() {
        return UserTaskState.of("Created");
    }

    public String toString() {
        return "UserTaskState [terminate=" + this.terminate + ", name=" + this.name + "]";
    }

    public static enum TerminationType {
        COMPLETED,
        ABORT,
        FAILED,
        EXITED,
        OBSOLETE,
        ERROR;

    }
}

