/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.cloud.kubernetes.client;

import io.fabric8.kubernetes.client.BaseClient;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import java.net.MalformedURLException;
import java.net.URL;
import okhttp3.OkHttpClient;

public final class KogitoKubeConfig {
    public static final String KNATIVE_ISTIO_NAMESPACE = "istio-system";
    private static final String NAMESPACE_REPLACE = "@ns@";
    private static final String KNATIVE_SERVICE_SERVICE_URL = "apis/serving.knative.dev/v1alpha1/namespaces/@ns@/services";
    private static final String KNATIVE_ISTIO_GATEWAY_URL = "api/v1/namespaces/istio-system/services/istio-ingressgateway";
    private KubernetesClient kubernetesClient;

    public KogitoKubeConfig() {
        System.setProperty("kubernetes.auth.tryKubeConfig", "false");
        this.kubernetesClient = new DefaultKubernetesClient();
    }

    public KogitoKubeConfig(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
    }

    public OkHttpClient getHttpClient() {
        return ((BaseClient)this.kubernetesClient).getHttpClient();
    }

    public URL getMasterUrl() {
        return this.kubernetesClient.getMasterUrl();
    }

    public String getKNativeServiceServiceURL(String namespace) throws MalformedURLException {
        if (namespace == null || namespace.isEmpty()) {
            throw new IllegalArgumentException("A namespace should be provided when using KNative service operations");
        }
        StringBuilder sb = new StringBuilder(this.getMasterUrl().toString());
        sb.append(KNATIVE_SERVICE_SERVICE_URL.replaceFirst(NAMESPACE_REPLACE, namespace));
        return sb.toString();
    }

    public String getKNativeIstioGatewayURL() throws MalformedURLException {
        StringBuilder sb = new StringBuilder(this.getMasterUrl().toString());
        sb.append(KNATIVE_ISTIO_GATEWAY_URL);
        return sb.toString();
    }

    public URL getServiceOperationURL(String namespace) throws MalformedURLException {
        OperationSupport services = (OperationSupport)this.kubernetesClient.services();
        return services.getNamespacedUrl(namespace);
    }
}

