/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.cloud.kubernetes.client.operations;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.IOException;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;
import org.kie.kogito.cloud.kubernetes.client.KogitoKubeClientException;
import org.kie.kogito.cloud.kubernetes.client.operations.MapWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationsResponseParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationsResponseParser.class);
    private final String response;
    private final ObjectMapper mapper;

    public OperationsResponseParser(String response) {
        this.response = response;
        this.mapper = new ObjectMapper();
        this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.mapper.setDateFormat((DateFormat)new StdDateFormat().withColonInTimeZone(true));
    }

    public String asJson() {
        return this.response;
    }

    public Map<String, Object> asMap() {
        if (this.response == null || this.response.isEmpty()) {
            return new HashMap<String, Object>();
        }
        try {
            TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
            LOGGER.debug("Trying to parse API response {}", (Object)this.response);
            return (Map)this.mapper.readValue(this.response, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw new KogitoKubeClientException("Error while trying to parse API response", e);
        }
    }

    public MapWalker asMapWalker() {
        return this.asMapWalker(false);
    }

    public MapWalker asMapWalker(boolean safeNull) {
        if (this.response == null || this.response.isEmpty()) {
            return new MapWalker(new HashMap(), safeNull);
        }
        return new MapWalker(this.asMap(), safeNull);
    }
}

