/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.cloud.kubernetes.client.operations;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.Request;
import okhttp3.Response;
import org.kie.kogito.cloud.kubernetes.client.KogitoKubeClientException;
import org.kie.kogito.cloud.kubernetes.client.KogitoKubeConfig;
import org.kie.kogito.cloud.kubernetes.client.operations.Operations;
import org.kie.kogito.cloud.kubernetes.client.operations.OperationsResponseParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOperations
implements Operations {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseOperations.class);
    private static final String EMPTY_JSON = "{}";
    private final KogitoKubeConfig clientConfig;

    public BaseOperations(KogitoKubeConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public final KogitoKubeConfig getClientConfig() {
        return this.clientConfig;
    }

    private URL doBuildUrl(String namespace, Map<String, String> labels) {
        try {
            StringBuilder sb = new StringBuilder(this.buildBaseUrl(namespace));
            if (labels != null) {
                sb.append("?").append("labelSelector").append("=");
                sb.append(this.buildLabelSelectorParam(labels));
            }
            return new URL(sb.toString());
        }
        catch (Exception e) {
            throw new KogitoKubeClientException(String.format("Error while trying to build URL for the Service API: '%s'", e.getMessage()), e);
        }
    }

    private String buildLabelSelectorParam(Map<String, String> labels) {
        if (labels != null) {
            return labels.entrySet().stream().map(label -> String.format(label.getValue() == null || ((String)label.getValue()).isEmpty() ? "%s" : "%s=%s", label.getKey(), label.getValue())).collect(Collectors.joining(","));
        }
        return "";
    }

    private Response doExecute(String namespace, Map<String, String> labels) throws IOException {
        URL url = this.doBuildUrl(namespace, labels);
        Request request = new Request.Builder().url(url).build();
        LOGGER.debug("About to query the Kubernetes API with url {} with label selector {} in namespace  '{}'", new Object[]{url, labels, namespace});
        return this.clientConfig.getHttpClient().newCall(request).execute();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected OperationsResponseParser execute(String namespace, Map<String, String> labels) {
        try (Response response = this.doExecute(namespace, labels);){
            LOGGER.debug("Response Headers received from the Kube cluster: {}", (Object)response.headers());
            if (response.isSuccessful()) {
                String data = response.body().string();
                LOGGER.debug("Received response data from Kube API: {}", (Object)data);
                OperationsResponseParser operationsResponseParser = new OperationsResponseParser(data);
                return operationsResponseParser;
            }
            if (response.code() == 404) {
                LOGGER.debug("No resources found in namespace '{}' with labels {}", (Object)namespace, labels);
                OperationsResponseParser operationsResponseParser = new OperationsResponseParser(EMPTY_JSON);
                return operationsResponseParser;
            }
            if (response.code() != 403 && response.code() != 401) {
                throw new KogitoKubeClientException(String.format("Error trying to fetch the Kubernetes API. Response is: %s", response));
            }
            throw new KogitoKubeClientException(String.format("Tried to fetch for resources, got unauthorized/forbidden response: %s. Make sure to correctly set a Service Account with permissions to fetch the resource.", response));
        }
        catch (KogitoKubeClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KogitoKubeClientException(String.format("Error trying to fetch the Kubernetes API - '%s: %s'", e.getClass(), e.getMessage()), e);
        }
    }

    protected abstract String buildBaseUrl(String var1) throws MalformedURLException;
}

