/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.cloud.kubernetes.client.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MapWalker {
    private Object theMap;
    private boolean safeNull;

    public MapWalker(Object theMap, boolean safeNull) {
        this.theMap = theMap;
        this.safeNull = safeNull;
    }

    public MapWalker(Object theMap) {
        this(theMap, false);
    }

    public <K, V> Map<K, V> asMap() {
        if (this.theMap instanceof Map) {
            return (Map)this.theMap;
        }
        throw new IllegalArgumentException(String.format("The object %s is not a map. Impossible to get", this.theMap));
    }

    public <K, V> List<Map<K, V>> asList() {
        if (this.theMap instanceof List) {
            return (List)this.theMap;
        }
        throw new IllegalArgumentException(String.format("The object %s is not a list. Impossible to get", this.theMap));
    }

    public MapWalker mapToMap(String key) {
        if (this.theMap instanceof Map) {
            this.theMap = ((Map)this.theMap).get(key);
            if (this.safeNull && this.theMap == null) {
                this.theMap = new HashMap();
            }
            return this;
        }
        throw new IllegalArgumentException(String.format("The object %s is not a map. Impossible to walk to the key '%s'", this.theMap, key));
    }

    public MapWalker mapToListMap(String key) {
        if (this.theMap instanceof Map) {
            this.theMap = (List)((Map)this.theMap).get(key);
            if (this.safeNull && this.theMap == null) {
                this.theMap = new ArrayList();
            }
            return this;
        }
        throw new IllegalArgumentException(String.format("The object %s is not a list. Impossible to walk to the key %s", this.theMap, key));
    }

    public MapWalker listToMap(int index) {
        if (this.theMap instanceof List) {
            List theList = (List)this.theMap;
            this.theMap = theList != null && theList.size() > index ? (Map)theList.get(index) : new HashMap();
            return this;
        }
        throw new IllegalArgumentException(String.format("The object %s is not a list. Impossible to walk to the index '%d'", this.theMap, index));
    }
}

