/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.cloud.workitems.service.discovery;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.kogito.cloud.kubernetes.client.KogitoKubeClient;
import org.kie.kogito.cloud.kubernetes.client.operations.MapWalker;
import org.kie.kogito.cloud.workitems.ServiceInfo;
import org.kie.kogito.cloud.workitems.service.discovery.BaseServiceDiscovery;

public class IstioServiceDiscovery
extends BaseServiceDiscovery {
    private static final String SERVICE_KEY_HOST = "HOST";
    private static final String KEY_STATUS = "status";
    private static final String KEY_DOMAIN = "domain";
    private static final String KEY_URL = "url";
    private static final String PROTOCOL_REGEX = "^(http:\\/\\/www\\.|https:\\/\\/www\\.|http:\\/\\/|https:\\/\\/)";
    private final String istioGatewayUrl;

    public IstioServiceDiscovery(KogitoKubeClient kubeClient, String istioGatewayUrl) {
        super(kubeClient);
        this.istioGatewayUrl = istioGatewayUrl;
    }

    @Override
    protected List<Map<String, Object>> query(String namespace, Map<String, String> labels) {
        return this.kubeClient.knativeService().listNamespaced(namespace, labels).asMapWalker().mapToListMap("items").asList();
    }

    @Override
    protected ServiceInfo buildService(List<Map<String, Object>> services, String service) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Map response = new MapWalker(services.get(0)).mapToMap(KEY_STATUS).asMap();
        String endpoint = "";
        if (response.containsKey(KEY_URL)) {
            endpoint = response.get(KEY_URL).toString().replaceAll(PROTOCOL_REGEX, "").replaceAll(PROTOCOL_REGEX, "");
            LOGGER.debug("Found key {} using endpoint: {}", (Object)KEY_URL, (Object)endpoint);
        } else {
            endpoint = response.get(KEY_DOMAIN).toString();
            LOGGER.debug("Found key {} using endpoint: {}", (Object)KEY_DOMAIN, (Object)endpoint);
        }
        headers.put(SERVICE_KEY_HOST, endpoint);
        LOGGER.debug("Headers to be used for requests {}", headers);
        return new ServiceInfo(String.format("%s%s", this.istioGatewayUrl, service), headers);
    }
}

