/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.cloud.workitems;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.kogito.cloud.kubernetes.client.DefaultKogitoKubeClient;
import org.kie.kogito.cloud.kubernetes.client.KogitoKubeClient;
import org.kie.kogito.cloud.workitems.HttpMethods;
import org.kie.kogito.cloud.workitems.ServiceInfo;
import org.kie.kogito.cloud.workitems.service.discovery.ServiceDiscovery;
import org.kie.kogito.cloud.workitems.service.discovery.ServiceDiscoveryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiscoveredServiceWorkItemHandler
implements WorkItemHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscoveredServiceWorkItemHandler.class);
    protected static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    protected static final List<String> INTERNAL_FIELDS = Arrays.asList("TaskName", "ActorId", "GroupId", "Priority", "Comment", "Skippable", "Content", "Model", "Namespace");
    private Map<String, ServiceInfo> serviceEndpoints;
    private OkHttpClient http;
    private ObjectMapper mapper;
    private ServiceDiscovery serviceDiscovery;
    private KogitoKubeClient kubeClient;

    public DiscoveredServiceWorkItemHandler() {
        this(null);
    }

    protected DiscoveredServiceWorkItemHandler(KogitoKubeClient kubeClient) {
        LOGGER.debug("New instance of discovered service work item with kubeclient: {}", (Object)kubeClient);
        this.mapper = new ObjectMapper();
        this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.mapper.setDateFormat((DateFormat)new StdDateFormat().withColonInTimeZone(true));
        this.kubeClient = kubeClient;
        this.serviceEndpoints = new ConcurrentHashMap<String, ServiceInfo>();
    }

    protected ServiceDiscovery buildServiceDiscovery() {
        if (this.kubeClient == null) {
            LOGGER.debug("Kubernetes client configuration is null, using default values");
            this.kubeClient = new DefaultKogitoKubeClient();
        }
        if (this.serviceDiscovery == null) {
            LOGGER.debug("Creating and caching a new reference of ServiceDiscoveryFactory");
            this.serviceDiscovery = new ServiceDiscoveryFactory(this.kubeClient).build();
        }
        return this.serviceDiscovery;
    }

    protected ServiceDiscovery buildServiceDiscovery(KogitoKubeClient kubeClient) {
        this.kubeClient = kubeClient;
        return this.buildServiceDiscovery();
    }

    protected OkHttpClient buildHttpClient() {
        if (this.http == null) {
            LOGGER.debug("Creating and caching a new reference of OkHttpClient");
            this.http = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();
        }
        return this.http;
    }

    protected boolean removeService(String serviceName) {
        return this.serviceEndpoints.remove(serviceName) != null;
    }

    protected void addServices(String serviceName, ServiceInfo service) {
        if (service != null) {
            LOGGER.debug("Adding a new service '{}' to the registry: {}", (Object)serviceName, (Object)service);
            this.serviceEndpoints.put(serviceName, service);
        }
    }

    protected Map<String, ServiceInfo> getServices() {
        return Collections.unmodifiableMap(this.serviceEndpoints);
    }

    protected ServiceInfo findEndpoint(String namespace, String service) {
        LOGGER.debug("Looking for services. Services discovered so far {}", this.serviceEndpoints);
        return this.buildServiceDiscovery().findEndpoint(namespace, service).orElseThrow(() -> new RuntimeException("No endpoint found for service " + service));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, Object> discoverAndCall(WorkItem workItem, String namespace, String serviceName, HttpMethods method) {
        HashMap<String, Object> data = new HashMap<String, Object>(workItem.getParameters());
        String service = (String)data.remove(serviceName);
        INTERNAL_FIELDS.forEach(field -> data.remove(field));
        ServiceInfo endpoint = this.serviceEndpoints.computeIfAbsent(service, s -> this.findEndpoint(namespace, (String)s));
        LOGGER.debug("Found endpoint for service {} with location {}", (Object)service, (Object)endpoint);
        RequestBody body = this.produceRequestPayload(data);
        Request request = null;
        switch (method) {
            case POST: {
                request = this.producePostRequest(endpoint, body);
                break;
            }
            case GET: {
                request = this.produceGetRequest(endpoint);
                break;
            }
            case PUT: {
                request = this.producePutRequest(endpoint, body);
                break;
            }
            case DELETE: {
                request = this.produceDeleteRequest(endpoint, body);
                break;
            }
        }
        try (Response response = this.buildHttpClient().newCall(request).execute();){
            Map<String, Object> results;
            Map<String, Object> map = results = this.produceResultsFromResponse(response);
            return map;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected RequestBody produceRequestPayload(Map<String, Object> data) {
        if (data == null) {
            return null;
        }
        try {
            String json = this.mapper.writeValueAsString(data);
            LOGGER.debug("Sending body {}", (Object)json);
            RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
            return body;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error when producing request payload", e);
        }
    }

    protected Map<String, Object> produceResultsFromResponse(Response response) throws IOException {
        String payload = response.body().string();
        LOGGER.debug("Resonse code {} and payload {}", (Object)response.code(), (Object)payload);
        if (!response.isSuccessful()) {
            throw new RuntimeException("Unsuccessful response from service " + response.message() + " (code " + response.code() + ")");
        }
        Map results = (Map)this.mapper.readValue(payload, Map.class);
        return results;
    }

    protected Request producePostRequest(ServiceInfo endpoint, RequestBody body) {
        Request.Builder builder = new Request.Builder().url(endpoint.getUrl()).post(body);
        this.applyHeaders(endpoint, builder);
        return builder.build();
    }

    protected Request produceGetRequest(ServiceInfo endpoint) {
        Request.Builder builder = new Request.Builder().url(endpoint.getUrl()).get();
        this.applyHeaders(endpoint, builder);
        return builder.build();
    }

    protected Request producePutRequest(ServiceInfo endpoint, RequestBody body) {
        Request.Builder builder = new Request.Builder().url(endpoint.getUrl()).put(body);
        this.applyHeaders(endpoint, builder);
        return builder.build();
    }

    protected Request produceDeleteRequest(ServiceInfo endpoint, RequestBody body) {
        Request.Builder builder = new Request.Builder().url(endpoint.getUrl()).delete(body);
        this.applyHeaders(endpoint, builder);
        return builder.build();
    }

    protected void applyHeaders(ServiceInfo endpoint, Request.Builder builder) {
        if (endpoint.getHeaders() != null) {
            for (Map.Entry<String, String> header : endpoint.getHeaders().entrySet()) {
                builder.addHeader(header.getKey(), header.getValue());
            }
        }
    }
}

