/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.cloud.workitems.service.discovery;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.kie.kogito.cloud.kubernetes.client.KogitoKubeClient;
import org.kie.kogito.cloud.workitems.ServiceInfo;
import org.kie.kogito.cloud.workitems.service.discovery.ServiceDiscovery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseServiceDiscovery
implements ServiceDiscovery {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseServiceDiscovery.class);
    static final String KEY_ITEMS = "items";
    static final String KEY_SPEC = "spec";
    static final String KEY_CLUSTER_IP = "clusterIP";
    static final String DEFAULT_PROTOCOL = "http://";
    static final int DEFAULT_PORT = 80;
    protected KogitoKubeClient kubeClient;

    public BaseServiceDiscovery(KogitoKubeClient kubeClient) {
        this.kubeClient = kubeClient;
    }

    protected abstract List<Map<String, Object>> query(String var1, Map<String, String> var2);

    protected abstract ServiceInfo buildService(List<Map<String, Object>> var1, String var2);

    private Map<String, String> buildLabelMap(String labelKey, String labelValue) {
        if (labelKey == null || labelKey.isEmpty()) {
            return null;
        }
        return Collections.singletonMap(labelKey, labelValue);
    }

    @Override
    public final Optional<ServiceInfo> findEndpoint(String namespace, String labelKey, String labelValue) {
        LOGGER.debug("About to query for endpoints in namespace {} with labels {}:{}", new Object[]{namespace, labelKey, labelValue});
        List<Map<String, Object>> services = this.query(namespace, this.buildLabelMap(labelKey, labelValue));
        LOGGER.debug("Result of services query: {}", services);
        if (services.size() > 1) {
            LOGGER.warn("Found more than one endpoint using labels {}:{}. Returning the first one in the list. Try to be more specific in the query search.", (Object)labelKey, (Object)labelValue);
        } else if (services.isEmpty()) {
            LOGGER.warn("Haven't found any endpoint in the namespace {} with labels {}:{}", new Object[]{namespace, labelKey, labelValue});
            return Optional.empty();
        }
        return Optional.of(this.buildService(services, labelValue == null || labelValue.isEmpty() ? labelKey : labelValue));
    }

    @Override
    public final Optional<ServiceInfo> findEndpoint(String namespace, String service) {
        return this.findEndpoint(namespace, service, null);
    }
}

