/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.cloud.workitems.service.discovery;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.kogito.cloud.kubernetes.client.KogitoKubeClient;
import org.kie.kogito.cloud.kubernetes.client.operations.MapWalker;
import org.kie.kogito.cloud.workitems.ServiceInfo;
import org.kie.kogito.cloud.workitems.service.discovery.BaseServiceDiscovery;

public class KubernetesServiceDiscovery
extends BaseServiceDiscovery {
    private static final String KEY_PORTS = "ports";
    private static final String KEY_PORT = "port";

    public KubernetesServiceDiscovery(KogitoKubeClient kubeClient) {
        super(kubeClient);
    }

    @Override
    protected List<Map<String, Object>> query(String namespace, Map<String, String> labels) {
        return this.kubeClient.services().listNamespaced(namespace, labels).asMapWalker().mapToListMap("items").asList();
    }

    @Override
    protected ServiceInfo buildService(List<Map<String, Object>> services, String service) {
        StringBuilder url = new StringBuilder();
        url.append("http://").append(new MapWalker(services.get(0)).mapToMap("spec").asMap().get("clusterIP")).append(":").append(new MapWalker(services.get(0)).mapToMap("spec").mapToListMap(KEY_PORTS).listToMap(0).asMap().get(KEY_PORT)).append("/").append(service);
        return new ServiceInfo(url.toString(), new HashMap<String, String>());
    }
}

