/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.cloud.workitems.service.discovery;

import org.kie.kogito.cloud.kubernetes.client.DefaultKogitoKubeClient;
import org.kie.kogito.cloud.kubernetes.client.KogitoKubeClient;
import org.kie.kogito.cloud.workitems.service.discovery.IstioServiceDiscovery;
import org.kie.kogito.cloud.workitems.service.discovery.KubernetesServiceDiscovery;
import org.kie.kogito.cloud.workitems.service.discovery.ServiceDiscovery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceDiscoveryFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceDiscoveryFactory.class);
    private KogitoKubeClient kubeClient;
    private boolean istioEnv;
    private String istioGatewayUrl;

    public ServiceDiscoveryFactory(KogitoKubeClient kubeClient) {
        this.kubeClient = kubeClient;
        this.discoverIstioGatewayUrl();
    }

    public ServiceDiscovery build() {
        if (this.kubeClient == null) {
            this.kubeClient = new DefaultKogitoKubeClient();
        }
        if (this.isIstioEnv()) {
            return new IstioServiceDiscovery(this.kubeClient, this.getIstioGatewayUrl());
        }
        return new KubernetesServiceDiscovery(this.kubeClient);
    }

    public boolean isIstioEnv() {
        return this.istioEnv;
    }

    public String getIstioGatewayUrl() {
        return this.istioGatewayUrl;
    }

    private void discoverIstioGatewayUrl() {
        LOGGER.debug("Trying to discover Istio Gateway URL");
        try {
            String clusterIp = (String)this.kubeClient.istioGateway().get().asMapWalker(true).mapToMap("spec").asMap().get("clusterIP");
            if (clusterIp == null || clusterIp.isEmpty()) {
                LOGGER.debug("Not in Istio environment");
                this.istioEnv = false;
                this.istioGatewayUrl = null;
            } else {
                this.istioEnv = true;
                this.istioGatewayUrl = "http://" + clusterIp + ":" + 80 + "/";
                LOGGER.debug("Discovered Istio Gateway URL {}. Will use Istio as default service discovery mechanism", (Object)this.istioGatewayUrl);
            }
        }
        catch (Exception ex) {
            this.istioEnv = false;
            this.istioGatewayUrl = null;
            LOGGER.debug("Failed to look up for Istio Gateway URL: '{}'. Enable debug logging to view the full stack trace. Failing back to standard Service API.", (Object)ex.getMessage());
            LOGGER.debug("Error while trying to fetch for Istio Gateway URL", (Throwable)ex);
        }
    }
}

