/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.cloudevents;

import java.util.List;
import java.util.stream.Collectors;
import org.kie.kogito.event.ChannelType;
import org.kie.kogito.event.CloudEventMeta;
import org.kie.kogito.event.EventKind;
import org.kie.kogito.event.Topic;
import org.kie.kogito.services.event.TopicDiscovery;

public abstract class AbstractTopicDiscovery
implements TopicDiscovery {
    public static final Topic DEFAULT_INCOMING_CHANNEL = new Topic("kogito_incoming_stream", ChannelType.INCOMING);
    public static final Topic DEFAULT_OUTGOING_CHANNEL = new Topic("kogito_outgoing_stream", ChannelType.OUTGOING);

    protected abstract List<Topic> getTopics();

    public List<Topic> getTopics(List<CloudEventMeta> events) {
        List<Topic> topics = this.getTopics();
        if (events == null || events.isEmpty()) {
            return topics;
        }
        events.forEach(e -> {
            if (e.getKind() == EventKind.CONSUMED && topics.stream().noneMatch(t -> t.getType() == ChannelType.INCOMING)) {
                topics.add(DEFAULT_INCOMING_CHANNEL);
            } else if (e.getKind() == EventKind.PRODUCED && topics.stream().noneMatch(t -> t.getType() == ChannelType.OUTGOING)) {
                topics.add(DEFAULT_OUTGOING_CHANNEL);
            }
        });
        topics.forEach(t -> {
            if (t.getType() == ChannelType.INCOMING) {
                t.setEventsMeta(events.stream().filter(e -> e.getKind() == EventKind.CONSUMED).collect(Collectors.toList()));
            } else {
                t.setEventsMeta(events.stream().filter(e -> e.getKind() == EventKind.PRODUCED).collect(Collectors.toList()));
            }
        });
        return topics;
    }
}

