/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.cloudevents.quarkus.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.jackson.JsonFormat;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.kie.kogito.addon.cloudevents.quarkus.QuarkusCloudEventPublisher;
import org.kie.kogito.addon.cloudevents.quarkus.http.CloudEventInvalidDataException;
import org.kie.kogito.addon.cloudevents.quarkus.http.Responses;
import org.kie.kogito.cloudevents.Printer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuarkusCloudEventResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractQuarkusCloudEventResource.class);
    @Inject
    ObjectMapper objectMapper;
    @Inject
    QuarkusCloudEventPublisher publisher;

    @PostConstruct
    public void setup() {
        this.objectMapper.registerModule((Module)JsonFormat.getCloudEventJacksonModule());
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    public Response cloudEventListener(CloudEvent event) {
        try {
            this.publisher.produce(this.serialize(event));
            return Response.ok().build();
        }
        catch (Exception ex) {
            return Responses.errorProcessingCloudEvent(ex);
        }
    }

    protected String serialize(CloudEvent event) throws JsonProcessingException, CloudEventInvalidDataException {
        LOGGER.debug("CloudEvent to publish: {}", (Object)Printer.beautify((CloudEvent)event));
        if (!this.isSupportedContentType(event)) {
            LOGGER.warn("Content-Type of the received CloudEvent '{}' is not supported. Content-type is {}. Assuming application/json.", (Object)event.getType(), (Object)event.getDataContentType());
            this.checkEventDataIsValidJSON(event);
            CloudEvent newEvent = CloudEventBuilder.v1((CloudEvent)event).withDataContentType("application/json").build();
            String newDecodedEvent = this.objectMapper.writeValueAsString((Object)newEvent);
            LOGGER.debug("Decoded event {}", (Object)newDecodedEvent);
            return newDecodedEvent;
        }
        return this.objectMapper.writeValueAsString((Object)event);
    }

    private void checkEventDataIsValidJSON(CloudEvent event) throws CloudEventInvalidDataException {
        try {
            this.objectMapper.readTree(event.getData());
        }
        catch (IOException e) {
            throw new CloudEventInvalidDataException(event, (Throwable)e);
        }
    }

    private boolean isSupportedContentType(CloudEvent event) {
        return event.getDataContentType() != null && MediaType.APPLICATION_JSON_TYPE.isCompatible(MediaType.valueOf((String)event.getDataContentType()));
    }
}

