/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.api;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import org.kie.kogito.codegen.api.GeneratedFileType;

public class GeneratedFile {
    private final Path path;
    private final String pathAsString;
    private final byte[] contents;
    private final GeneratedFileType type;

    public GeneratedFile(GeneratedFileType type, Path path, String contents) {
        this(type, path, contents.getBytes(StandardCharsets.UTF_8));
    }

    public GeneratedFile(GeneratedFileType type, Path path, byte[] contents) {
        this(type, path, path.toString(), contents);
    }

    public GeneratedFile(GeneratedFileType type, String relativePath, String contents) {
        this(type, relativePath, contents.getBytes(StandardCharsets.UTF_8));
    }

    public GeneratedFile(GeneratedFileType type, String relativePath, byte[] contents) {
        this(type, Path.of(relativePath, new String[0]), relativePath, contents);
    }

    private GeneratedFile(GeneratedFileType type, Path path, String pathAsString, byte[] contents) {
        this.type = type;
        this.path = path;
        this.pathAsString = pathAsString;
        this.contents = contents;
    }

    public String relativePath() {
        return this.pathAsString;
    }

    public Path path() {
        return this.path;
    }

    public byte[] contents() {
        return this.contents;
    }

    public GeneratedFileType type() {
        return this.type;
    }

    public GeneratedFileType.Category category() {
        return this.type.category();
    }

    public String toString() {
        return "GeneratedFile{type=" + this.type + ", path='" + this.path + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneratedFile that = (GeneratedFile)o;
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }
}

