/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.api.utils;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.UnaryOperator;

public class AppPaths {
    public static final String TARGET_DIR = "target";
    private final Set<Path> projectPaths = new LinkedHashSet<Path>();
    private final Collection<Path> classesPaths = new ArrayList<Path>();
    private final boolean isJar;
    private final Path resourcesPath;
    private final Path outputTarget;

    public static AppPaths fromProjectDir(Path projectDir, Path outputTarget) {
        return new AppPaths(Collections.singleton(projectDir), Collections.emptyList(), false, BuildTool.MAVEN, "main", outputTarget);
    }

    public static AppPaths fromQuarkus(Path outputTarget, Iterable<Path> paths, BuildTool bt) {
        LinkedHashSet<Path> projectPaths = new LinkedHashSet<Path>();
        ArrayList<Path> classesPaths = new ArrayList<Path>();
        boolean isJar = false;
        for (Path path : paths) {
            PathType pathType = AppPaths.getPathType(path);
            switch (pathType) {
                case CLASSES: {
                    classesPaths.add(path);
                    projectPaths.add(path.getParent().getParent());
                    break;
                }
                case TEST_CLASSES: {
                    projectPaths.add(path.getParent().getParent());
                    break;
                }
                case JAR: {
                    isJar = true;
                    classesPaths.add(path);
                    projectPaths.add(path.getParent().getParent());
                    break;
                }
                case UNKNOWN: {
                    classesPaths.add(path);
                    projectPaths.add(path);
                }
            }
        }
        return new AppPaths(projectPaths, classesPaths, isJar, bt, "main", outputTarget);
    }

    public static AppPaths fromTestDir(Path projectDir) {
        return new AppPaths(Collections.singleton(projectDir), Collections.emptyList(), false, BuildTool.MAVEN, "test", Paths.get(projectDir.toString(), TARGET_DIR));
    }

    private static PathType getPathType(Path archiveLocation) {
        String path = archiveLocation.toString();
        if (path.endsWith(TARGET_DIR + File.separator + "classes")) {
            return PathType.CLASSES;
        }
        if (path.endsWith(TARGET_DIR + File.separator + "test-classes")) {
            return PathType.TEST_CLASSES;
        }
        if (path.endsWith(".jar") || path.endsWith(".jar.original")) {
            return PathType.JAR;
        }
        return PathType.UNKNOWN;
    }

    private AppPaths(Set<Path> projectPaths, Collection<Path> classesPaths, boolean isJar, BuildTool bt, String resourcesBasePath, Path outputTarget) {
        this.isJar = isJar;
        this.projectPaths.addAll(projectPaths);
        this.classesPaths.addAll(classesPaths);
        this.outputTarget = outputTarget;
        this.resourcesPath = bt == BuildTool.GRADLE ? Paths.get("", new String[0]) : Paths.get("src", resourcesBasePath, "resources");
    }

    public Path[] getPaths() {
        if (this.isJar) {
            return this.getJarPaths();
        }
        return this.getResourcePaths();
    }

    public Path getFirstProjectPath() {
        return this.projectPaths.iterator().next();
    }

    private Path[] getJarPaths() {
        if (!this.isJar) {
            throw new IllegalStateException("Not a jar");
        }
        return this.classesPaths.toArray(new Path[this.classesPaths.size()]);
    }

    public File[] getResourceFiles() {
        return (File[])this.projectPaths.stream().map(p -> p.resolve(this.resourcesPath).toFile()).toArray(File[]::new);
    }

    public Path[] getResourcePaths() {
        return this.transformPaths(this.projectPaths, p -> p.resolve(this.resourcesPath));
    }

    public Path[] getSourcePaths() {
        return this.transformPaths(this.projectPaths, p -> p.resolve("src"));
    }

    public Collection<Path> getClassesPaths() {
        return Collections.unmodifiableCollection(this.classesPaths);
    }

    public Path getOutputTarget() {
        return this.outputTarget;
    }

    private Path[] transformPaths(Collection<Path> paths, UnaryOperator<Path> f) {
        return (Path[])paths.stream().map(f).toArray(Path[]::new);
    }

    public String toString() {
        return "AppPaths{projectPaths=" + this.projectPaths + ", classesPaths=" + this.classesPaths + ", isJar=" + this.isJar + "}";
    }

    private static enum PathType {
        CLASSES,
        TEST_CLASSES,
        JAR,
        UNKNOWN;

    }

    public static enum BuildTool {
        MAVEN,
        GRADLE;

    }
}

