/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.api.context;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.kie.kogito.KogitoGAV;
import org.kie.kogito.codegen.api.AddonsConfig;
import org.kie.kogito.codegen.api.ApplicationSection;
import org.kie.kogito.codegen.api.Generator;
import org.kie.kogito.codegen.api.context.KogitoApplicationPropertyProvider;
import org.kie.kogito.codegen.api.di.DependencyInjectionAnnotator;
import org.kie.kogito.codegen.api.rest.RestAnnotator;
import org.kie.kogito.codegen.api.utils.AppPaths;

public interface KogitoBuildContext {
    public static final String APPLICATION_PROPERTIES_FILE_NAME = "application.properties";
    public static final String DEFAULT_PACKAGE_NAME = "org.kie.kogito.app";
    public static final String KOGITO_GENERATE_REST = "kogito.generate.rest";
    public static final String KOGITO_GENERATE_DI = "kogito.generate.di";

    public static String generateRESTConfigurationKeyForResource(String generatorType) {
        return String.format("%s.%s", KOGITO_GENERATE_REST, generatorType);
    }

    public boolean hasClassAvailable(String var1);

    public DependencyInjectionAnnotator getDependencyInjectionAnnotator();

    public void setDependencyInjectionAnnotator(DependencyInjectionAnnotator var1);

    default public boolean hasDI() {
        return this.getDependencyInjectionAnnotator() != null && "true".equalsIgnoreCase(this.getApplicationProperty(KOGITO_GENERATE_DI).orElse("true"));
    }

    public RestAnnotator getRestAnnotator();

    public void setRestAnnotator(RestAnnotator var1);

    public Set<ApplicationSection> getApplicationSections();

    public void addAllApplicationSections(Set<ApplicationSection> var1);

    public void addApplicationSection(ApplicationSection var1);

    default public boolean hasRESTForGenerator(Generator generator) {
        return this.hasRESTGloballyAvailable() && "true".equalsIgnoreCase(this.getApplicationProperty(KogitoBuildContext.generateRESTConfigurationKeyForResource(generator.name())).orElse("true"));
    }

    default public boolean hasRESTGloballyAvailable() {
        return this.getRestAnnotator() != null && "true".equalsIgnoreCase(this.getApplicationProperty(KOGITO_GENERATE_REST).orElse("true"));
    }

    default public boolean isValidationSupported() {
        return this.hasClassAvailable("javax.validation.constraints.NotNull");
    }

    default public boolean isOpenApiSpecSupported() {
        return this.hasClassAvailable("org.eclipse.microprofile.openapi.annotations.media.Schema");
    }

    public Optional<String> getApplicationProperty(String var1);

    public Collection<String> getApplicationProperties();

    public void setApplicationProperty(String var1, String var2);

    public String getPackageName();

    public AddonsConfig getAddonsConfig();

    public ClassLoader getClassLoader();

    public AppPaths getAppPaths();

    public Map<String, Object> getContextAttributes();

    public void addContextAttribute(String var1, Object var2);

    public <T> T getContextAttribute(String var1, Class<T> var2);

    public String name();

    public Optional<KogitoGAV> getGAV();

    default public Map<String, String> getPropertiesMap() {
        return this.getApplicationProperties().stream().filter(key -> this.getApplicationProperty((String)key).isPresent()).collect(Collectors.toUnmodifiableMap(key -> key, key -> this.getApplicationProperty((String)key).get()));
    }

    public static interface Builder {
        public Builder withPackageName(String var1);

        public Builder withApplicationPropertyProvider(KogitoApplicationPropertyProvider var1);

        public Builder withApplicationProperties(Properties var1);

        public Builder withApplicationProperties(File ... var1);

        public Builder withAddonsConfig(AddonsConfig var1);

        public Builder withClassAvailabilityResolver(Predicate<String> var1);

        public Builder withClassLoader(ClassLoader var1);

        public Builder withAppPaths(AppPaths var1);

        public Builder withGAV(KogitoGAV var1);

        public KogitoBuildContext build();
    }
}

