/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.api.context.impl;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import javax.lang.model.SourceVersion;
import org.kie.kogito.KogitoGAV;
import org.kie.kogito.codegen.api.AddonsConfig;
import org.kie.kogito.codegen.api.ApplicationSection;
import org.kie.kogito.codegen.api.context.KogitoApplicationPropertyProvider;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.di.DependencyInjectionAnnotator;
import org.kie.kogito.codegen.api.rest.RestAnnotator;
import org.kie.kogito.codegen.api.utils.AddonsConfigDiscovery;
import org.kie.kogito.codegen.api.utils.AppPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKogitoBuildContext
implements KogitoBuildContext {
    public static final String DEFAULT_GROUP_ID = "org.kie.kogito";
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractKogitoBuildContext.class);
    protected final Predicate<String> classAvailabilityResolver;
    protected final KogitoApplicationPropertyProvider applicationProperties;
    protected final String packageName;
    protected final AddonsConfig addonsConfig;
    protected final ClassLoader classLoader;
    protected final AppPaths appPaths;
    protected final String contextName;
    protected final Map<String, Object> contextAttributes;
    protected final KogitoGAV gav;
    protected Set<ApplicationSection> applicationSections;
    protected DependencyInjectionAnnotator dependencyInjectionAnnotator;
    protected RestAnnotator restAnnotator;

    protected AbstractKogitoBuildContext(AbstractBuilder builder, DependencyInjectionAnnotator dependencyInjectionAnnotator, RestAnnotator restAnnotator, String contextName) {
        this.packageName = builder.packageName;
        this.classAvailabilityResolver = builder.classAvailabilityResolver;
        this.dependencyInjectionAnnotator = dependencyInjectionAnnotator;
        this.restAnnotator = restAnnotator;
        this.applicationProperties = builder.applicationProperties;
        this.addonsConfig = builder.addonsConfig != null ? builder.addonsConfig : AddonsConfigDiscovery.discover(this);
        this.classLoader = builder.classLoader;
        this.appPaths = builder.appPaths;
        this.gav = builder.gav;
        this.contextName = contextName;
        this.contextAttributes = new HashMap<String, Object>();
        this.applicationSections = new HashSet<ApplicationSection>();
    }

    protected static Properties load(File ... resourcePaths) {
        Properties applicationProperties = new Properties();
        for (File resourcePath : resourcePaths) {
            try (FileReader fileReader = new FileReader(new File(resourcePath, "application.properties"));){
                applicationProperties.load(fileReader);
            }
            catch (IOException ioe) {
                LOGGER.debug("Unable to load 'application.properties'.");
            }
        }
        return applicationProperties;
    }

    @Override
    public boolean hasClassAvailable(String fqcn) {
        return this.classAvailabilityResolver.test(fqcn);
    }

    @Override
    public DependencyInjectionAnnotator getDependencyInjectionAnnotator() {
        return this.dependencyInjectionAnnotator;
    }

    @Override
    public void setDependencyInjectionAnnotator(DependencyInjectionAnnotator dependencyInjectionAnnotator) {
        this.dependencyInjectionAnnotator = dependencyInjectionAnnotator;
    }

    @Override
    public RestAnnotator getRestAnnotator() {
        return this.restAnnotator;
    }

    @Override
    public void setRestAnnotator(RestAnnotator restAnnotator) {
        this.restAnnotator = restAnnotator;
    }

    @Override
    public Optional<String> getApplicationProperty(String property) {
        return this.applicationProperties.getApplicationProperty(property);
    }

    @Override
    public <T> Optional<T> getApplicationProperty(String property, Class<T> clazz) {
        return this.applicationProperties.getApplicationProperty(property, clazz);
    }

    @Override
    public Collection<String> getApplicationProperties() {
        return this.applicationProperties.getApplicationProperties();
    }

    @Override
    public void setApplicationProperty(String key, String value) {
        this.applicationProperties.setApplicationProperty(key, value);
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public AddonsConfig getAddonsConfig() {
        return this.addonsConfig;
    }

    @Override
    public String name() {
        return this.contextName;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public AppPaths getAppPaths() {
        return this.appPaths;
    }

    @Override
    public Optional<KogitoGAV> getGAV() {
        return Optional.ofNullable(this.gav);
    }

    @Override
    public Map<String, Object> getContextAttributes() {
        return Collections.unmodifiableMap(this.contextAttributes);
    }

    @Override
    public <T> T getContextAttribute(String key, Class<T> asClass) {
        Object output = this.contextAttributes.get(key);
        if (output == null) {
            return null;
        }
        if (asClass.isAssignableFrom(output.getClass())) {
            return asClass.cast(output);
        }
        throw new AssertionError((Object)("Impossible to cast '" + key + "' key value as " + asClass.getName() + ", found " + output.getClass().getCanonicalName()));
    }

    @Override
    public void addContextAttribute(String key, Object value) {
        this.contextAttributes.put(key, value);
    }

    @Override
    public Set<ApplicationSection> getApplicationSections() {
        return Collections.unmodifiableSet(this.applicationSections);
    }

    @Override
    public void addAllApplicationSections(Set<ApplicationSection> applicationSections) {
        this.applicationSections.addAll(applicationSections);
    }

    @Override
    public void addApplicationSection(ApplicationSection applicationSection) {
        this.applicationSections.add(applicationSection);
    }

    public String toString() {
        return "KogitoBuildContext{contextName='" + this.contextName + "', applicationProperties=" + this.applicationProperties + ", packageName='" + this.packageName + "', addonsConfig=" + this.addonsConfig + "}";
    }

    protected static abstract class AbstractBuilder
    implements KogitoBuildContext.Builder {
        protected String packageName = "org.kie.kogito.app";
        protected KogitoApplicationPropertyProvider applicationProperties = KogitoApplicationPropertyProvider.of(new Properties());
        protected AddonsConfig addonsConfig;
        protected ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        protected Predicate<String> classAvailabilityResolver = this::hasClass;
        protected AppPaths appPaths = AppPaths.fromProjectDir(new File(".").toPath(), Path.of(".", "target"));
        protected KogitoGAV gav;

        protected AbstractBuilder() {
        }

        @Override
        public KogitoBuildContext.Builder withPackageName(String packageName) {
            Objects.requireNonNull(packageName, "packageName cannot be null");
            if (!SourceVersion.isName(packageName)) {
                throw new IllegalArgumentException(MessageFormat.format("Package name \"{0}\" is not valid. It should be a valid Java package name.", packageName));
            }
            if (!packageName.equals(AbstractKogitoBuildContext.DEFAULT_GROUP_ID)) {
                this.packageName = packageName;
            } else {
                LOGGER.warn("Skipping the package provided because invalid: '{}' (current value '{}')", (Object)packageName, (Object)this.packageName);
            }
            return this;
        }

        @Override
        public KogitoBuildContext.Builder withApplicationPropertyProvider(KogitoApplicationPropertyProvider applicationProperties) {
            Objects.requireNonNull(applicationProperties, "applicationPropertiesProvider cannot be null");
            this.applicationProperties = applicationProperties;
            return this;
        }

        @Override
        public KogitoBuildContext.Builder withApplicationProperties(Properties applicationProperties) {
            Objects.requireNonNull(applicationProperties, "applicationProperties cannot be null");
            this.applicationProperties = KogitoApplicationPropertyProvider.of(applicationProperties);
            return this;
        }

        @Override
        public KogitoBuildContext.Builder withApplicationProperties(File ... files) {
            this.applicationProperties = KogitoApplicationPropertyProvider.of(AbstractKogitoBuildContext.load(files));
            return this;
        }

        @Override
        public KogitoBuildContext.Builder withAddonsConfig(AddonsConfig addonsConfig) {
            this.addonsConfig = addonsConfig;
            return this;
        }

        @Override
        public KogitoBuildContext.Builder withClassAvailabilityResolver(Predicate<String> classAvailabilityResolver) {
            Objects.requireNonNull(classAvailabilityResolver, "classAvailabilityResolver cannot be null");
            this.classAvailabilityResolver = classAvailabilityResolver;
            return this;
        }

        @Override
        public KogitoBuildContext.Builder withClassLoader(ClassLoader classLoader) {
            Objects.requireNonNull(classLoader, "classLoader cannot be null");
            this.classLoader = classLoader;
            return this;
        }

        @Override
        public KogitoBuildContext.Builder withAppPaths(AppPaths appPaths) {
            Objects.requireNonNull(appPaths, "appPaths cannot be null");
            this.appPaths = appPaths;
            return this;
        }

        @Override
        public KogitoBuildContext.Builder withGAV(KogitoGAV gav) {
            Objects.requireNonNull(gav, "gav cannot be null");
            this.gav = gav;
            return this;
        }

        private boolean hasClass(String className) {
            try {
                this.classLoader.loadClass(className);
                return true;
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        }
    }
}

