/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.api.io;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.kie.api.io.Resource;

public class CollectedResource {
    private final Path basePath;
    private final Resource resource;

    public CollectedResource(Path basePath, Resource resource) {
        if (!basePath.toString().endsWith(".jar") && !Paths.get(resource.getSourcePath(), new String[0]).toAbsolutePath().startsWith(basePath.toAbsolutePath())) {
            throw new IllegalArgumentException(String.format("basePath %s is not a prefix to the resource sourcePath %s", basePath, resource.getSourcePath()));
        }
        this.basePath = basePath;
        this.resource = resource;
    }

    public Path basePath() {
        return this.basePath;
    }

    public Resource resource() {
        return this.resource;
    }
}

