/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.api.utils;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.UnaryOperator;

public class AppPaths {
    private final Set<Path> projectPaths = new LinkedHashSet<Path>();
    private final Collection<Path> classesPaths = new ArrayList<Path>();
    private final boolean isJar;

    public static AppPaths fromProjectDir(Path projectDir) {
        return new AppPaths(Collections.singleton(projectDir), Collections.emptyList(), false);
    }

    public static AppPaths fromQuarkus(Iterable<Path> paths) {
        LinkedHashSet<Path> projectPaths = new LinkedHashSet<Path>();
        ArrayList<Path> classesPaths = new ArrayList<Path>();
        boolean isJar = false;
        for (Path path : paths) {
            PathType pathType = AppPaths.getPathType(path);
            switch (pathType) {
                case CLASSES: {
                    classesPaths.add(path);
                    projectPaths.add(path.getParent().getParent());
                    break;
                }
                case TEST_CLASSES: {
                    projectPaths.add(path.getParent().getParent());
                    break;
                }
                case JAR: {
                    isJar = true;
                    classesPaths.add(path);
                    projectPaths.add(path.getParent().getParent());
                    break;
                }
                case UNKNOWN: {
                    classesPaths.add(path);
                    projectPaths.add(path);
                }
            }
        }
        return new AppPaths(projectPaths, classesPaths, isJar);
    }

    private static PathType getPathType(Path archiveLocation) {
        String path = archiveLocation.toString();
        if (path.endsWith("target" + File.separator + "classes")) {
            return PathType.CLASSES;
        }
        if (path.endsWith("target" + File.separator + "test-classes")) {
            return PathType.TEST_CLASSES;
        }
        if (path.endsWith(".jar") || path.endsWith(".jar.original")) {
            return PathType.JAR;
        }
        return PathType.UNKNOWN;
    }

    private AppPaths(Set<Path> projectPaths, Collection<Path> classesPaths, boolean isJar) {
        this.isJar = isJar;
        this.projectPaths.addAll(projectPaths);
        this.classesPaths.addAll(classesPaths);
    }

    public Path[] getPaths() {
        if (this.isJar) {
            return this.getJarPaths();
        }
        return this.getResourcePaths();
    }

    public Path getFirstProjectPath() {
        return this.projectPaths.iterator().next();
    }

    public Path getFirstClassesPath() {
        return this.classesPaths.iterator().next();
    }

    private Path[] getJarPaths() {
        if (!this.isJar) {
            throw new IllegalStateException("Not a jar");
        }
        return this.classesPaths.toArray(new Path[this.classesPaths.size()]);
    }

    public File[] getResourceFiles() {
        return (File[])this.projectPaths.stream().map(p -> p.resolve("src/main/resources").toFile()).toArray(File[]::new);
    }

    public Path[] getResourcePaths() {
        return this.transformPaths(this.projectPaths, p -> p.resolve("src/main/resources"));
    }

    public Path[] getSourcePaths() {
        return this.transformPaths(this.projectPaths, p -> p.resolve("src"));
    }

    public Collection<Path> getProjectPaths() {
        return Collections.unmodifiableCollection(this.projectPaths);
    }

    public Collection<Path> getClassesPaths() {
        return Collections.unmodifiableCollection(this.classesPaths);
    }

    private Path[] transformPaths(Collection<Path> paths, UnaryOperator<Path> f) {
        return (Path[])paths.stream().map(f).toArray(Path[]::new);
    }

    private static enum PathType {
        CLASSES,
        TEST_CLASSES,
        JAR,
        UNKNOWN;

    }
}

