/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.api.context;

import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import org.kie.kogito.internal.utils.ConversionUtils;

public interface KogitoApplicationPropertyProvider {
    public static KogitoApplicationPropertyProvider of(final Properties properties) {
        return new KogitoApplicationPropertyProvider(){

            @Override
            public Optional<String> getApplicationProperty(String property) {
                return Optional.ofNullable(properties.getProperty(property));
            }

            @Override
            public Collection<String> getApplicationProperties() {
                return properties.stringPropertyNames();
            }

            @Override
            public void setApplicationProperty(String key, String value) {
                properties.put(key, value);
            }

            @Override
            public <T> Optional<T> getApplicationProperty(String property, Class<T> clazz) {
                return Optional.ofNullable(ConversionUtils.convert((Object)properties.getProperty(property), clazz));
            }

            @Override
            public void removeApplicationProperty(String key) {
                properties.remove(key);
            }
        };
    }

    public Optional<String> getApplicationProperty(String var1);

    public <T> Optional<T> getApplicationProperty(String var1, Class<T> var2);

    public Collection<String> getApplicationProperties();

    public void setApplicationProperty(String var1, String var2);

    public void removeApplicationProperty(String var1);
}

