/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.api.template;

import com.github.javaparser.ParseProblemException;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.template.InvalidTemplateException;
import org.kie.kogito.codegen.api.template.TemplateInstantiationException;

public final class TemplatedGenerator {
    public static final String DEFAULT_TEMPLATE_BASE_PATH = "/class-templates/";
    protected static final String TEMPLATE_FORMAT = "{0}{1}{2}{3}";
    protected static final String TEMPLATE_SUFFIX = "Template.java";
    protected final String packageName;
    protected final String sourceFilePath;
    protected final String templateBasePath;
    protected final String templateName;
    protected final String targetTypeName;
    protected final String fallbackContext;
    protected final KogitoBuildContext context;

    private TemplatedGenerator(KogitoBuildContext context, String packageName, String targetTypeName, String templateBasePath, String templateName, String fallbackContext) {
        this.context = context;
        this.packageName = packageName;
        this.targetTypeName = targetTypeName;
        this.fallbackContext = fallbackContext;
        String targetCanonicalName = this.packageName + "." + this.targetTypeName;
        this.sourceFilePath = targetCanonicalName.replace('.', '/') + ".java";
        this.templateBasePath = templateBasePath;
        this.templateName = templateName;
    }

    public String generatedFilePath() {
        return this.sourceFilePath;
    }

    public String templateName() {
        return this.templateName;
    }

    public String targetTypeName() {
        return this.targetTypeName;
    }

    public Optional<CompilationUnit> compilationUnit() {
        String selectedResource = this.templatePath();
        if (selectedResource == null) {
            return Optional.empty();
        }
        try {
            CompilationUnit compilationUnit = StaticJavaParser.parse((InputStream)this.getResource(selectedResource)).setPackageDeclaration(this.packageName);
            return Optional.of(compilationUnit);
        }
        catch (ParseProblemException | AssertionError e) {
            throw new TemplateInstantiationException(this.targetTypeName, selectedResource, (Throwable)e);
        }
    }

    public CompilationUnit compilationUnitOrThrow(String errorMessage) {
        return this.compilationUnit().orElseThrow(() -> new InvalidTemplateException(this, errorMessage));
    }

    public CompilationUnit compilationUnitOrThrow() {
        return this.compilationUnitOrThrow("Missing template");
    }

    public String templatePath() {
        String resourcePath = this.uncheckedTemplatePath();
        String fallbackPath = TemplatedGenerator.createTemplatePath(this.templateBasePath, this.templateName, this.fallbackContext);
        if (this.getResource(resourcePath) != null) {
            return resourcePath;
        }
        if (this.fallbackContext != null && this.getResource(fallbackPath) != null) {
            return fallbackPath;
        }
        return null;
    }

    public String uncheckedTemplatePath() {
        return TemplatedGenerator.createTemplatePath(this.templateBasePath, this.templateName, this.context.name());
    }

    private InputStream getResource(String path) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream is = classLoader.getResourceAsStream(path);
        if (is == null) {
            return this.getClass().getResourceAsStream(path);
        }
        return is;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static String createTemplatePath(String basePath, String templateName, String context) {
        return MessageFormat.format(TEMPLATE_FORMAT, basePath, templateName, context, TEMPLATE_SUFFIX);
    }

    public static class Builder {
        protected String packageName;
        protected String templateBasePath = "/class-templates/";
        protected String targetTypeName;
        protected String fallbackContext;

        public Builder withTemplateBasePath(String templateBasePath) {
            Objects.requireNonNull(templateBasePath, "templateBasePath cannot be null");
            String prefix = !templateBasePath.startsWith("/") ? "/" : "";
            String postfix = !templateBasePath.endsWith("/") ? "/" : "";
            this.templateBasePath = prefix + templateBasePath + postfix;
            return this;
        }

        public Builder withPackageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public Builder withTargetTypeName(String targetTypeName) {
            this.targetTypeName = targetTypeName;
            return this;
        }

        public Builder withFallbackContext(String fallbackContext) {
            this.fallbackContext = fallbackContext;
            return this;
        }

        public TemplatedGenerator build(KogitoBuildContext context, String templateName) {
            Objects.requireNonNull(context, "context cannot be null");
            Objects.requireNonNull(templateName, "templateName cannot be null");
            String aPackageName = this.packageName == null ? context.getPackageName() : this.packageName;
            String aTargetTypeName = this.targetTypeName == null ? templateName : this.targetTypeName;
            return new TemplatedGenerator(context, aPackageName, aTargetTypeName, this.templateBasePath, templateName, this.fallbackContext);
        }
    }
}

