/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.manager;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.codegen.common.GeneratedFile;
import org.drools.codegen.common.GeneratedFileType;
import org.drools.codegen.common.GeneratedFileWriter;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.util.PortablePath;
import org.kie.memorycompiler.CompilationProblem;
import org.kie.memorycompiler.CompilationResult;
import org.kie.memorycompiler.JavaCompiler;
import org.kie.memorycompiler.JavaCompilerFactory;
import org.kie.memorycompiler.JavaCompilerSettings;
import org.kie.memorycompiler.JavaConfiguration;
import org.kie.memorycompiler.resources.ResourceReader;
import org.kie.memorycompiler.resources.ResourceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompilerHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompilerHelper.class);
    private static final JavaCompiler JAVA_COMPILER = JavaCompilerFactory.loadCompiler((JavaConfiguration.CompilerType)JavaConfiguration.CompilerType.NATIVE, (String)"17");
    private static final GeneratedFileWriter.Builder GENERATED_FILE_WRITER_BUILDER = GeneratedFileWriter.builder((String)"kogito", (String)"kogito.codegen.resources.directory", (String)"kogito.codegen.sources.directory");
    public static final String SOURCES = "SOURCES";
    public static final String RESOURCES = "RESOURCES";

    private CompilerHelper() {
    }

    public static void compileAndDumpGeneratedSources(Collection<GeneratedFile> generatedSources, ClassLoader classLoader, List<String> runtimeClassPathElements, File baseDir, String javaSourceEncoding, String javaSourceVersion, String javaTargetVersion) {
        CompilerHelper.compileAndWriteClasses(generatedSources, classLoader, CompilerHelper.buildJavaCompilerSettings(runtimeClassPathElements, javaSourceEncoding, javaSourceVersion, javaTargetVersion), CompilerHelper.getGeneratedFileWriter(baseDir));
        CompilerHelper.writeFiles(generatedSources, baseDir);
    }

    public static void dumpResources(Collection<GeneratedFile> resources, File baseDir) {
        CompilerHelper.writeFiles(resources, baseDir);
    }

    static void writeFiles(Collection<GeneratedFile> toWrite, File baseDir) {
        GeneratedFileWriter writer = CompilerHelper.getGeneratedFileWriter(baseDir);
        toWrite.forEach(generatedFile -> CompilerHelper.writeGeneratedFile(generatedFile, writer));
    }

    static void writeGeneratedFile(GeneratedFile generatedFile, GeneratedFileWriter writer) {
        LOGGER.info("Writing compiled class: {}", (Object)generatedFile.relativePath());
        writer.write(generatedFile);
    }

    static void compileAndWriteClasses(Collection<GeneratedFile> generatedClasses, ClassLoader classLoader, JavaCompilerSettings javaCompilerSettings, GeneratedFileWriter fileWriter) {
        MemoryFileSystem srcMfs = new MemoryFileSystem();
        MemoryFileSystem trgMfs = new MemoryFileSystem();
        String[] sources = new String[generatedClasses.size()];
        int index = 0;
        for (GeneratedFile entry : generatedClasses) {
            String fileName = entry.relativePath();
            sources[index++] = fileName;
            srcMfs.write(fileName, entry.contents());
        }
        if (sources.length > 0) {
            CompilationResult result = JAVA_COMPILER.compile(sources, (ResourceReader)srcMfs, (ResourceStore)trgMfs, classLoader, javaCompilerSettings);
            if (result.getErrors().length > 0) {
                throw new IllegalStateException(Arrays.stream(result.getErrors()).map(CompilationProblem::getMessage).collect(Collectors.joining(",")));
            }
            for (PortablePath path : trgMfs.getFilePaths()) {
                byte[] data = trgMfs.getBytes(path);
                CompilerHelper.writeGeneratedFile(new GeneratedFile(GeneratedFileType.COMPILED_CLASS, path.asString(), data), fileWriter);
            }
        }
    }

    static GeneratedFileWriter getGeneratedFileWriter(File baseDir) {
        return GENERATED_FILE_WRITER_BUILDER.build(Path.of(baseDir.getAbsolutePath(), new String[0]));
    }

    static JavaCompilerSettings buildJavaCompilerSettings(List<String> runtimeClassPathElements, String sourceEncoding, String sourceVersion, String targetVersion) {
        JavaCompilerSettings settings = new JavaCompilerSettings();
        for (String path : runtimeClassPathElements) {
            settings.addClasspath(new File(path));
        }
        settings.setSourceEncoding(sourceEncoding);
        settings.setSourceVersion(sourceVersion);
        settings.setTargetVersion(targetVersion);
        return settings;
    }
}

