/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.manager;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.drools.codegen.common.GeneratedFile;
import org.drools.codegen.common.GeneratedFileType;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.core.ApplicationGenerator;
import org.kie.kogito.codegen.core.utils.ApplicationGeneratorDiscovery;

public class GenerateModelHelper {
    private GenerateModelHelper() {
    }

    public static Map<String, Collection<GeneratedFile>> generateModelFiles(KogitoBuildContext kogitoBuildContext, boolean generatePartial) {
        ApplicationGenerator appGen = ApplicationGeneratorDiscovery.discover((KogitoBuildContext)kogitoBuildContext);
        Collection generatedFiles = generatePartial ? appGen.generateComponents() : appGen.generate();
        HashSet generatedClasses = new HashSet();
        HashSet generatedResources = new HashSet();
        generatedFiles.forEach(generatedFile -> {
            switch (generatedFile.category()) {
                case SOURCE: {
                    generatedClasses.add(generatedFile);
                    break;
                }
                case INTERNAL_RESOURCE: 
                case STATIC_HTTP_RESOURCE: {
                    generatedResources.add(generatedFile);
                    break;
                }
                case COMPILED_CLASS: {
                    generatedResources.add(new GeneratedFile(GeneratedFileType.COMPILED_CLASS, GenerateModelHelper.convertPath(generatedFile.path().toString()), generatedFile.contents()));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected file with category: " + generatedFile.category());
                }
            }
        });
        return Map.of("SOURCES", generatedClasses, "RESOURCES", generatedResources);
    }

    private static String convertPath(String toConvert) {
        return toConvert.replace('.', File.separatorChar) + ".class";
    }
}

