/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.manager.processes;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.drools.codegen.common.GeneratedFile;
import org.drools.codegen.common.GeneratedFileType;
import org.kie.kogito.Model;
import org.kie.kogito.ProcessInput;
import org.kie.kogito.UserTask;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.core.utils.GeneratedFileValidation;
import org.kie.kogito.codegen.json.JsonSchemaGenerator;
import org.kie.kogito.codegen.manager.util.CodeGenManagerUtil;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;
import org.kie.kogito.codegen.process.persistence.marshaller.MarshallerGenerator;
import org.kie.kogito.codegen.process.persistence.marshaller.ReflectionMarshallerGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ReflectionProtoGenerator;
import org.reflections.Reflections;

public class PersistenceGenerationHelper {
    private PersistenceGenerationHelper() {
    }

    public static Map<String, Collection<GeneratedFile>> generatePersistenceFiles(KogitoBuildContext context, ClassLoader projectClassloader, String schemaVersion) {
        try {
            Reflections reflections = CodeGenManagerUtil.getReflections(projectClassloader);
            Set modelClasses = reflections.getSubTypesOf(Model.class);
            ReflectionProtoGenerator protoGenerator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().build((Collection)modelClasses);
            PersistenceGenerator persistenceGenerator = new PersistenceGenerator(context, (ProtoGenerator)protoGenerator, (MarshallerGenerator)new ReflectionMarshallerGenerator(context, protoGenerator.getDataClasses()));
            Map<String, Collection<GeneratedFile>> toReturn = PersistenceGenerationHelper.getMappedGeneratedFiles(persistenceGenerator);
            Stream<Class<?>> processClassStream = reflections.getTypesAnnotatedWith(ProcessInput.class).stream();
            toReturn.get("RESOURCES").addAll(PersistenceGenerationHelper.generateJsonSchemaFromClasses(processClassStream, schemaVersion));
            Stream<Class<?>> userTaskClassStream = reflections.getTypesAnnotatedWith(UserTask.class).stream();
            toReturn.get("RESOURCES").addAll(PersistenceGenerationHelper.generateJsonSchemaFromClasses(userTaskClassStream, schemaVersion));
            return toReturn;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error during processing model classes", e);
        }
    }

    static Map<String, Collection<GeneratedFile>> getMappedGeneratedFiles(PersistenceGenerator persistenceGenerator) {
        Collection persistenceFiles = persistenceGenerator.generate();
        GeneratedFileValidation.validateGeneratedFileTypes((Collection)persistenceFiles, Arrays.asList(GeneratedFileType.Category.SOURCE, GeneratedFileType.Category.INTERNAL_RESOURCE, GeneratedFileType.Category.STATIC_HTTP_RESOURCE));
        HashSet generatedClasses = new HashSet();
        HashSet generatedResources = new HashSet();
        persistenceFiles.forEach(generatedFile -> {
            switch (generatedFile.category()) {
                case SOURCE: {
                    generatedClasses.add(generatedFile);
                    break;
                }
                case INTERNAL_RESOURCE: 
                case STATIC_HTTP_RESOURCE: {
                    generatedResources.add(generatedFile);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected file with category: " + generatedFile.category());
                }
            }
        });
        return Map.of("SOURCES", generatedClasses, "RESOURCES", generatedResources);
    }

    private static Collection<GeneratedFile> generateJsonSchemaFromClasses(Stream<Class<?>> classes, String schemaVersion) throws IOException {
        return new JsonSchemaGenerator.ClassBuilder(classes).withSchemaVersion(schemaVersion).build().generate();
    }
}

