/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.manager.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.drools.codegen.common.AppPaths;
import org.kie.kogito.KogitoGAV;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.JavaKogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.SpringBootKogitoBuildContext;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGenManagerUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeGenManagerUtil.class);
    public static final PathMatcher DRL_FILE_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**.drl");

    public static KogitoBuildContext discoverKogitoRuntimeContext(ClassLoader projectClassLoader, Path projectDir, KogitoGAV kogitoGAV, ProjectParameters projectParameters, Predicate<String> classAvaialbilityPredicate) {
        AppPaths appPaths = AppPaths.fromProjectDir((Path)projectDir);
        KogitoBuildContext context = CodeGenManagerUtil.contextBuilder(projectParameters.framework).withClassAvailabilityResolver(classAvaialbilityPredicate).withClassSubTypeAvailabilityResolver(CodeGenManagerUtil.classSubTypeAvailabilityResolver(projectClassLoader)).withApplicationProperties(appPaths.getResourceFiles()).withPackageName("org.kie.kogito.app").withClassLoader(projectClassLoader).withAppPaths(appPaths).withGAV(kogitoGAV).build();
        CodeGenManagerUtil.additionalProperties(context, projectParameters);
        return context;
    }

    static KogitoBuildContext.Builder contextBuilder(Framework framework) {
        return switch (framework) {
            case Framework.QUARKUS -> QuarkusKogitoBuildContext.builder();
            case Framework.SPRING -> SpringBootKogitoBuildContext.builder();
            default -> JavaKogitoBuildContext.builder();
        };
    }

    static Optional<String> classToCheckForREST(Framework framework) {
        return switch (framework) {
            case Framework.QUARKUS -> Optional.of("jakarta.ws.rs.Path");
            case Framework.SPRING -> Optional.of("org.springframework.web.bind.annotation.RestController");
            default -> Optional.empty();
        };
    }

    static Optional<String> classToCheckForDI(Framework framework) {
        return switch (framework) {
            case Framework.QUARKUS -> Optional.of("jakarta.inject.Inject");
            case Framework.SPRING -> Optional.of("org.springframework.beans.factory.annotation.Autowired");
            default -> Optional.empty();
        };
    }

    static void overwritePropertiesIfNeeded(KogitoBuildContext context, ProjectParameters projectParameters) {
        CodeGenManagerUtil.overwritePropertyIfNeeded(context, "rules", projectParameters.generateRules());
        CodeGenManagerUtil.overwritePropertyIfNeeded(context, "processes", projectParameters.generateProcesses());
        CodeGenManagerUtil.overwritePropertyIfNeeded(context, "predictions", projectParameters.generatePredictions());
        CodeGenManagerUtil.overwritePropertyIfNeeded(context, "decisions", projectParameters.generateDecisions());
        CodeGenManagerUtil.overwritePropertyIfNeeded(context, "persistence", Boolean.toString(projectParameters.persistence()));
    }

    static void overwritePropertyIfNeeded(KogitoBuildContext context, String generatorName, String propertyValue) {
        if (propertyValue != null && !propertyValue.isEmpty()) {
            context.setApplicationProperty("kogito.codegen." + generatorName, propertyValue);
        }
    }

    static void additionalProperties(KogitoBuildContext context, ProjectParameters projectParameters) {
        CodeGenManagerUtil.classToCheckForREST(projectParameters.framework).ifPresent(restClass -> {
            if (!context.hasClassAvailable(restClass)) {
                LOGGER.info("Disabling REST generation because class '{}' is not available", restClass);
                context.setApplicationProperty("kogito.generate.rest", "false");
            }
        });
        CodeGenManagerUtil.classToCheckForDI(projectParameters.framework).ifPresent(diClass -> {
            if (!context.hasClassAvailable(diClass)) {
                LOGGER.info("Disabling dependency injection generation because class '{}", diClass);
                context.setApplicationProperty("kogito.generate.di", "false");
            }
        });
        CodeGenManagerUtil.overwritePropertiesIfNeeded(context, projectParameters);
    }

    public static Reflections getReflections(ClassLoader projectClassLoader) {
        URLClassLoader urlClassLoader = (URLClassLoader)projectClassLoader;
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addUrls(urlClassLoader.getURLs());
        builder.addClassLoaders(new ClassLoader[]{urlClassLoader});
        return new Reflections((Configuration)builder);
    }

    static Predicate<Class<?>> classSubTypeAvailabilityResolver(ClassLoader projectClassLoader) {
        return clazz -> CodeGenManagerUtil.getReflections(projectClassLoader).getSubTypesOf(clazz).stream().anyMatch(c -> !c.isInterface() && !Modifier.isAbstract(c.getModifiers()));
    }

    public static boolean isClassNameInUrlClassLoader(URL[] urls, String className) {
        boolean bl;
        URLClassLoader cl = new URLClassLoader(urls);
        try {
            cl.loadClass(className);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    cl.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        cl.close();
        return bl;
    }

    public static void deleteDrlFiles(Path directory) {
        try (Stream<Path> drlFiles = Files.find(directory, Integer.MAX_VALUE, (p, f) -> DRL_FILE_MATCHER.matches((Path)p), new FileVisitOption[0]);){
            drlFiles.forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error during .drl files deletion", e);
        }
    }

    public record ProjectParameters(Framework framework, String generateDecisions, String generatePredictions, String generateProcesses, String generateRules, boolean persistence) {
    }

    public static enum Framework {
        QUARKUS,
        SPRING,
        NONE;

    }
}

