/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.openapi.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class OpenApiClientOperation {
    private final String operationId;
    private String api;
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private String generatedClass;
    private String methodName;

    public OpenApiClientOperation(String operationId) {
        this.operationId = operationId;
    }

    public static Parameter newParameter(int order, String name) {
        Objects.requireNonNull(name, "Parameter name can't be null");
        return new Parameter(order, name);
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getApi() {
        return this.api;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = Objects.requireNonNullElse(parameters, Collections.emptyList());
    }

    public void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public String getGeneratedClass() {
        return this.generatedClass;
    }

    public void setGeneratedClass(String generatedClass) {
        this.generatedClass = generatedClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenApiClientOperation that = (OpenApiClientOperation)o;
        return Objects.equals(this.operationId, that.operationId) && Objects.equals(this.api, that.api) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.generatedClass, that.generatedClass) && Objects.equals(this.methodName, that.methodName);
    }

    public int hashCode() {
        return Objects.hash(this.operationId, this.api, this.parameters, this.generatedClass, this.methodName);
    }

    public String toString() {
        return this.operationId;
    }

    public static final class Parameter
    implements Comparable<Parameter> {
        private final Integer order;
        private final String specParameter;

        public Parameter(int order, String specParameter) {
            this.specParameter = specParameter;
            this.order = order;
        }

        public int getOrder() {
            return this.order;
        }

        public String getSpecParameter() {
            return this.specParameter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter that = (Parameter)o;
            return Objects.equals(this.order, that.order) && Objects.equals(this.specParameter, that.specParameter);
        }

        public int hashCode() {
            return Objects.hash(this.order, this.specParameter);
        }

        @Override
        public int compareTo(Parameter o) {
            return this.order.compareTo(o.getOrder());
        }
    }
}

