/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.openapi.client.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.openapi.client.OpenApiSpecDescriptor;
import org.kie.kogito.codegen.openapi.client.OpenApiUtils;
import org.kie.kogito.codegen.openapi.client.io.PathResolver;

public abstract class AbstractPathResolver
implements PathResolver {
    private static final String BASE_PATH = "openapi-spec-cache";
    protected final KogitoBuildContext context;

    public AbstractPathResolver(KogitoBuildContext context) {
        this.context = context;
    }

    private String getOutputPath() {
        Path outputPath = Paths.get(OpenApiUtils.getTempDirLocation(this.context), BASE_PATH);
        if (Files.notExists(outputPath, new LinkOption[0])) {
            try {
                Files.createDirectories(outputPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to create output path for OpenAPI spec files at " + outputPath, e);
            }
        }
        return outputPath.toString();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected String saveFileToTempLocation(OpenApiSpecDescriptor resource, InputStream stream) {
        String outputPath = Paths.get(this.getOutputPath(), resource.getId() + "_" + resource.getResourceName()).toString();
        try (ReadableByteChannel channel = Channels.newChannel(stream);){
            String string;
            try (FileOutputStream output = new FileOutputStream(outputPath);){
                output.getChannel().transferFrom(channel, 0L, Integer.MAX_VALUE);
                string = outputPath;
            }
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Fail to resolve remote file: " + resource.getURI().toString(), e);
        }
    }
}

