/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.openapi.client.io;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Objects;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.openapi.client.OpenApiSpecDescriptor;
import org.kie.kogito.codegen.openapi.client.OpenApiUtils;
import org.kie.kogito.codegen.openapi.client.io.AbstractPathResolver;

public class ClasspathResolver
extends AbstractPathResolver {
    private static final String CLASSPATH_SEP = ".jar!/";

    protected ClasspathResolver(KogitoBuildContext context) {
        super(context);
    }

    @Override
    public String resolve(OpenApiSpecDescriptor descriptor) {
        URL resource;
        OpenApiUtils.requireValidSpecURI(descriptor);
        Object resourceUri = descriptor.getURI().getPath();
        if ("classpath".equals(descriptor.getURI().getScheme())) {
            resourceUri = descriptor.getURI().getHost() + (String)resourceUri;
        }
        if ((resource = Objects.requireNonNull(this.context.getClassLoader().getResource((String)resourceUri), "Resource URI can't be found. Descriptor: " + descriptor)).getPath().contains(CLASSPATH_SEP)) {
            return this.saveFileToTempLocation(descriptor, this.context.getClassLoader().getResourceAsStream((String)resourceUri));
        }
        try {
            return Paths.get(resource.toURI()).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Classpath resource was resolved to an invalid URI for the Descriptor: " + descriptor, e);
        }
    }
}

