/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.openapi.client.io;

import java.util.Objects;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.openapi.client.OpenApiSpecDescriptor;
import org.kie.kogito.codegen.openapi.client.OpenApiUtils;
import org.kie.kogito.codegen.openapi.client.io.AbstractPathResolver;

public class ClasspathResolver
extends AbstractPathResolver {
    private static final String CLASSPATH_SEP = ".jar!/";

    protected ClasspathResolver(KogitoBuildContext context) {
        super(context);
    }

    @Override
    public String resolve(OpenApiSpecDescriptor descriptor) {
        String classpathPath;
        OpenApiUtils.requireValidSpecURI(descriptor);
        String resourceUri = descriptor.getURI().getPath();
        if ("classpath".equals(descriptor.getURI().getScheme())) {
            resourceUri = descriptor.getURI().getHost() + resourceUri;
        }
        if ((classpathPath = Objects.requireNonNull(this.context.getClassLoader().getResource(resourceUri), "Resource URI can't be found. Descriptor: " + descriptor).getPath()).contains(CLASSPATH_SEP)) {
            return this.saveFileToTempLocation(descriptor, this.context.getClassLoader().getResourceAsStream(resourceUri));
        }
        return classpathPath;
    }
}

