/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.core.io.CollectedResourceProducer;
import org.kie.kogito.codegen.process.ProcessCodegen;

class ProcessCodegenTest {
    private static final Path BASE_PATH = Paths.get("src/test/resources/", new String[0]).toAbsolutePath();
    private static final String MESSAGE_USERTASK_SOURCE = "usertask/UserTasksProcess.bpmn2";
    private static final Path MESSAGE_USERTASK_SOURCE_FULL_SOURCE = BASE_PATH.resolve("usertask/UserTasksProcess.bpmn2");

    ProcessCodegenTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void isEmpty(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.build();
        ProcessCodegen emptyCodeGenerator = ProcessCodegen.ofCollectedResources((KogitoBuildContext)context, Collections.emptyList());
        Assertions.assertThat((boolean)emptyCodeGenerator.isEmpty()).isTrue();
        Assertions.assertThat((boolean)emptyCodeGenerator.isEnabled()).isFalse();
        Collection emptyGeneratedFiles = emptyCodeGenerator.generate();
        Assertions.assertThat((int)emptyGeneratedFiles.size()).isEqualTo(0);
        ProcessCodegen codeGenerator = ProcessCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResourceProducer.fromFiles((Path)BASE_PATH, (File[])new File[]{MESSAGE_USERTASK_SOURCE_FULL_SOURCE.toFile()}));
        Assertions.assertThat((boolean)codeGenerator.isEmpty()).isFalse();
        Assertions.assertThat((boolean)codeGenerator.isEnabled()).isTrue();
        Collection generatedFiles = codeGenerator.generate();
        Assertions.assertThat((Collection)generatedFiles).hasSizeGreaterThanOrEqualTo(10);
    }
}

