/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.persistence;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.SpringBootKogitoBuildContext;
import org.kie.kogito.codegen.data.GeneratedPOJO;
import org.kie.kogito.codegen.process.persistence.AbstractPersistenceGeneratorTest;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ReflectionProtoGenerator;

class PostgrePersistenceGeneratorTest
extends AbstractPersistenceGeneratorTest {
    PostgrePersistenceGeneratorTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"persistenceTestContexts"})
    void testGeneratedFiles(KogitoBuildContext context) {
        context.setApplicationProperty("kogito.persistence.type", (Object)this.persistenceType());
        ReflectionProtoGenerator protoGenerator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().build(Collections.singleton(GeneratedPOJO.class));
        PersistenceGenerator persistenceGenerator = new PersistenceGenerator(context, (ProtoGenerator)protoGenerator);
        Collection generatedFiles = persistenceGenerator.generate();
        int factoryFiles = context instanceof SpringBootKogitoBuildContext ? 2 : 1;
        int marshallerFiles = PersistenceGenerator.hasProtoMarshaller((KogitoBuildContext)context) ? 14 : 0;
        int dataIndexFiles = PersistenceGenerator.hasDataIndexProto((KogitoBuildContext)context) ? 2 : 0;
        int expectedNumberOfFiles = factoryFiles + marshallerFiles + dataIndexFiles;
        Assertions.assertThat((Collection)generatedFiles).hasSize(expectedNumberOfFiles);
        Optional<GeneratedFile> persistenceFactoryImpl = generatedFiles.stream().filter(gf -> gf.relativePath().equals("org/kie/kogito/persistence/KogitoProcessInstancesFactoryImpl.java")).findFirst();
        Assertions.assertThat(persistenceFactoryImpl).isPresent();
        this.validateClassInCompilationUnit(persistenceFactoryImpl.get().contents());
        Optional<GeneratedFile> pgClientProducer = generatedFiles.stream().filter(gf -> gf.relativePath().equals("org/kie/kogito/persistence/PgClientProducer.java")).findFirst();
        if (context instanceof SpringBootKogitoBuildContext) {
            Assertions.assertThat(pgClientProducer).isPresent();
            this.validateClassInCompilationUnit(pgClientProducer.get().contents());
        } else {
            Assertions.assertThat(pgClientProducer).isEmpty();
        }
    }

    private void validateClassInCompilationUnit(byte[] contents) {
        CompilationUnit compilationUnit = StaticJavaParser.parse((InputStream)new ByteArrayInputStream(contents));
        compilationUnit.findFirst(ClassOrInterfaceDeclaration.class).orElseThrow(() -> new NoSuchElementException("Compilation unit doesn't contain a class or interface declaration!"));
    }

    @Override
    protected String persistenceType() {
        return "postgresql";
    }
}

