/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.persistence.proto;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.data.Address;
import org.kie.kogito.codegen.data.Answer;
import org.kie.kogito.codegen.data.AnswerBroken;
import org.kie.kogito.codegen.data.AnswerBrokenV2;
import org.kie.kogito.codegen.data.AnswerWithAnnotations;
import org.kie.kogito.codegen.data.EmptyConstructor;
import org.kie.kogito.codegen.data.GeneratedPOJO;
import org.kie.kogito.codegen.data.NotEmptyConstructor;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.codegen.data.PersonSubClass;
import org.kie.kogito.codegen.data.PersonVarInfo;
import org.kie.kogito.codegen.data.PersonWithAddress;
import org.kie.kogito.codegen.data.PersonWithAddresses;
import org.kie.kogito.codegen.data.PersonWithList;
import org.kie.kogito.codegen.data.Question;
import org.kie.kogito.codegen.data.QuestionWithAnnotatedEnum;
import org.kie.kogito.codegen.data.Travels;
import org.kie.kogito.codegen.process.persistence.proto.AbstractProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.Proto;
import org.kie.kogito.codegen.process.persistence.proto.ProtoEnum;
import org.kie.kogito.codegen.process.persistence.proto.ProtoField;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoMessage;

public abstract class AbstractProtoGeneratorTest<T> {
    protected static Collection<Class<?>> testClasses = Arrays.asList(Address.class, Answer.class, AnswerWithAnnotations.class, AnswerBroken.class, AnswerBrokenV2.class, EmptyConstructor.class, GeneratedPOJO.class, NotEmptyConstructor.class, Person.class, PersonVarInfo.class, PersonWithAddress.class, PersonWithAddresses.class, PersonWithList.class, Question.class, QuestionWithAnnotatedEnum.class, Travels.class, PersonSubClass.class);

    protected abstract ProtoGenerator.Builder<T, ? extends AbstractProtoGenerator<T>> protoGeneratorBuilder();

    protected abstract T convertToType(Class<?> var1);

    @Test
    void testTravelsProtoFile() {
        AbstractProtoGenerator generator = (AbstractProtoGenerator)this.protoGeneratorBuilder().build(Collections.emptyList());
        Proto proto = generator.generate("@Indexed", "@Field(index = Index.NO, store = Store.YES) @SortableField", "org.kie.kogito.test", this.convertToType(Travels.class), new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(2);
        ProtoMessage person = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getName()).isEqualTo("Person");
        Assertions.assertThat((String)person.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)person.getFields()).hasSize(5);
        ProtoField field = (ProtoField)person.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("adult");
        Assertions.assertThat((String)field.getType()).isEqualTo("bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(index = Index.NO, store = Store.YES) @SortableField");
        field = (ProtoField)person.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("age");
        Assertions.assertThat((String)field.getType()).isEqualTo("int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(index = Index.NO, store = Store.YES) @SortableField");
        field = (ProtoField)person.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("id");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(index = Index.NO, store = Store.YES) @SortableField");
        field = (ProtoField)person.getFields().get(3);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("name");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(index = Index.NO, store = Store.YES) @SortableField");
        field = (ProtoField)person.getFields().get(4);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("parent");
        Assertions.assertThat((String)field.getType()).isEqualTo("Person");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(index = Index.NO, store = Store.YES) @SortableField");
        ProtoMessage travel = (ProtoMessage)proto.getMessages().get(1);
        Assertions.assertThat((Object)travel).isNotNull();
        Assertions.assertThat((String)travel.getName()).isEqualTo("Travels");
        Assertions.assertThat((String)travel.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)travel.getFields()).hasSize(2);
        field = (ProtoField)travel.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("id");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(index = Index.YES, store = Store.YES) @SortableField");
    }

    @Test
    void testPersonProtoFile() {
        AbstractProtoGenerator generator = (AbstractProtoGenerator)this.protoGeneratorBuilder().withDataClasses(Collections.singleton(this.convertToType(Person.class))).build(null);
        Proto proto = generator.protoOfDataClasses("org.kie.kogito.test", new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        ProtoMessage person = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getName()).isEqualTo("Person");
        Assertions.assertThat((String)person.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)person.getFields()).hasSize(5);
        ProtoField field = (ProtoField)person.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("adult");
        Assertions.assertThat((String)field.getType()).isEqualTo("bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("age");
        Assertions.assertThat((String)field.getType()).isEqualTo("int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("id");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(3);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("name");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(4);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("parent");
        Assertions.assertThat((String)field.getType()).isEqualTo("Person");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
    }

    @Test
    void testPersonWithAddressProtoFile() {
        AbstractProtoGenerator generator = (AbstractProtoGenerator)this.protoGeneratorBuilder().withDataClasses(Collections.singleton(this.convertToType(PersonWithAddress.class))).build(null);
        Proto proto = generator.protoOfDataClasses("org.kie.kogito.test", new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(2);
        ProtoMessage address = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)address).isNotNull();
        Assertions.assertThat((String)address.getName()).isEqualTo("Address");
        Assertions.assertThat((String)address.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)address.getFields()).hasSize(4);
        ProtoField field = (ProtoField)address.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("city");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("country");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("street");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(3);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("zipCode");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        ProtoMessage person = (ProtoMessage)proto.getMessages().get(1);
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getName()).isEqualTo("PersonWithAddress");
        Assertions.assertThat((String)person.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)person.getFields()).hasSize(4);
        field = (ProtoField)person.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("address");
        Assertions.assertThat((String)field.getType()).isEqualTo("Address");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("adult");
        Assertions.assertThat((String)field.getType()).isEqualTo("bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("age");
        Assertions.assertThat((String)field.getType()).isEqualTo("int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(3);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("name");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
    }

    @Test
    void testPersonWithListProtoFile() {
        AbstractProtoGenerator generator = (AbstractProtoGenerator)this.protoGeneratorBuilder().withDataClasses(Collections.singleton(this.convertToType(PersonWithList.class))).build(null);
        Proto proto = generator.protoOfDataClasses("org.kie.kogito.test", new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        ProtoMessage address = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)address).isNotNull();
        Assertions.assertThat((String)address.getName()).isEqualTo("PersonWithList");
        Assertions.assertThat((String)address.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)address.getFields()).hasSize(7);
        ProtoField field = (ProtoField)address.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("adult");
        Assertions.assertThat((String)field.getType()).isEqualTo("bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("age");
        Assertions.assertThat((String)field.getType()).isEqualTo("int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("booleanList");
        Assertions.assertThat((String)field.getType()).isEqualTo("bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("repeated");
        field = (ProtoField)address.getFields().get(3);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("integerList");
        Assertions.assertThat((String)field.getType()).isEqualTo("int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("repeated");
        field = (ProtoField)address.getFields().get(4);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("longList");
        Assertions.assertThat((String)field.getType()).isEqualTo("int64");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("repeated");
        field = (ProtoField)address.getFields().get(5);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("name");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(6);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("stringList");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("repeated");
    }

    @Test
    void testPersonWithAddressesProtoFile() {
        AbstractProtoGenerator generator = (AbstractProtoGenerator)this.protoGeneratorBuilder().withDataClasses(Collections.singleton(this.convertToType(PersonWithAddresses.class))).build(null);
        Proto proto = generator.protoOfDataClasses("org.kie.kogito.test", new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(2);
        ProtoMessage address = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)address).isNotNull();
        Assertions.assertThat((String)address.getName()).isEqualTo("Address");
        Assertions.assertThat((String)address.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)address.getFields()).hasSize(4);
        ProtoField field = (ProtoField)address.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("city");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("country");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("street");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(3);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("zipCode");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        ProtoMessage person = (ProtoMessage)proto.getMessages().get(1);
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getName()).isEqualTo("PersonWithAddresses");
        Assertions.assertThat((String)person.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)person.getFields()).hasSize(4);
        field = (ProtoField)person.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("addresses");
        Assertions.assertThat((String)field.getType()).isEqualTo("Address");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("repeated");
        field = (ProtoField)person.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("adult");
        Assertions.assertThat((String)field.getType()).isEqualTo("bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("age");
        Assertions.assertThat((String)field.getType()).isEqualTo("int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(3);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("name");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
    }

    @Test
    void testPersonAsModelProtoFile() {
        AbstractProtoGenerator generator = (AbstractProtoGenerator)this.protoGeneratorBuilder().build(Collections.emptyList());
        Proto proto = generator.generate("@Indexed", "@Field(index = Index.NO, store = Store.YES) @SortableField", "org.kie.kogito.test.persons", this.convertToType(Person.class), new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test.persons");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        ProtoMessage person = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getName()).isEqualTo("Person");
        Assertions.assertThat((String)person.getComment()).isEqualTo("@Indexed");
        Assertions.assertThat((String)person.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)person.getFields()).hasSize(5);
        ProtoField field = (ProtoField)person.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("adult");
        Assertions.assertThat((String)field.getType()).isEqualTo("bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(index = Index.NO, store = Store.YES) @SortableField");
        field = (ProtoField)person.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("age");
        Assertions.assertThat((String)field.getType()).isEqualTo("int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(index = Index.NO, store = Store.YES) @SortableField");
        field = (ProtoField)person.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("id");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(index = Index.NO, store = Store.YES) @SortableField");
        field = (ProtoField)person.getFields().get(3);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("name");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(index = Index.NO, store = Store.YES) @SortableField");
        field = (ProtoField)person.getFields().get(4);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("parent");
        Assertions.assertThat((String)field.getType()).isEqualTo("Person");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(index = Index.NO, store = Store.YES) @SortableField");
    }

    @Test
    void testPersonWithVariableInfoAsModelProtoFile() {
        AbstractProtoGenerator generator = (AbstractProtoGenerator)this.protoGeneratorBuilder().build(Collections.emptyList());
        Proto proto = generator.generate("@Indexed", "@Field(index = Index.NO, store = Store.YES) @SortableField", "org.kie.kogito.test.persons", this.convertToType(PersonVarInfo.class), new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test.persons");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        ProtoMessage person = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getName()).isEqualTo("PersonVarInfo");
        Assertions.assertThat((String)person.getComment()).isEqualTo("@Indexed");
        Assertions.assertThat((String)person.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)person.getFields()).hasSize(3);
        ProtoField field = (ProtoField)person.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("adult");
        Assertions.assertThat((String)field.getType()).isEqualTo("bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(index = Index.NO, store = Store.YES) @SortableField");
        field = (ProtoField)person.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("age");
        Assertions.assertThat((String)field.getType()).isEqualTo("int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(index = Index.NO, store = Store.YES) @SortableField");
        field = (ProtoField)person.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("name");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(index = Index.NO, store = Store.YES) @SortableField\n @VariableInfo(tags=\"test\")");
    }

    @Test
    void testAnswerProtoFile() {
        AbstractProtoGenerator generator = (AbstractProtoGenerator)this.protoGeneratorBuilder().withDataClasses(Collections.singleton(this.convertToType(Answer.class))).build(null);
        Proto proto = generator.protoOfDataClasses("org.kie.kogito.test.persons", new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test.persons");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getEnums()).hasSize(1);
        ProtoEnum answer = (ProtoEnum)proto.getEnums().get(0);
        Assertions.assertThat((Object)answer).isNotNull();
        Assertions.assertThat((String)answer.getName()).isEqualTo("Answer");
        Assertions.assertThat((String)answer.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((Map)answer.getFields()).hasSize(3);
        Map fields = answer.getFields();
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)fields).isNotNull()).containsEntry((Object)"YES", (Object)2)).containsEntry((Object)"MAYBE", (Object)0)).containsEntry((Object)"NO", (Object)1);
    }

    @Test
    void testWrongEnumStatus() {
        AbstractProtoGenerator generatorBroken = (AbstractProtoGenerator)this.protoGeneratorBuilder().withDataClasses(Collections.singleton(this.convertToType(AnswerBroken.class))).build(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> generatorBroken.protoOfDataClasses("org.kie.kogito.test.persons", new String[0])).isInstanceOf(RuntimeException.class)).hasMessageContaining("Cannot mix annotation");
        AbstractProtoGenerator generatorBroken2 = (AbstractProtoGenerator)this.protoGeneratorBuilder().withDataClasses(Collections.singleton(this.convertToType(AnswerBrokenV2.class))).build(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> generatorBroken2.protoOfDataClasses("org.kie.kogito.test.persons", new String[0])).isInstanceOf(RuntimeException.class)).hasMessageContaining("Cannot mix annotation");
    }

    @Test
    void testAnswerWithAnnotationsProtoFile() {
        AbstractProtoGenerator generator = (AbstractProtoGenerator)this.protoGeneratorBuilder().withDataClasses(Collections.singleton(this.convertToType(AnswerWithAnnotations.class))).build(null);
        Proto proto = generator.protoOfDataClasses("org.kie.kogito.test.persons", new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test.persons");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getEnums()).hasSize(1);
        ProtoEnum answer = (ProtoEnum)proto.getEnums().get(0);
        Assertions.assertThat((Object)answer).isNotNull();
        Assertions.assertThat((String)answer.getName()).isEqualTo(AnswerWithAnnotations.class.getSimpleName());
        Assertions.assertThat((String)answer.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((Map)answer.getFields()).hasSize(3);
        Map fields = answer.getFields();
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)fields).isNotNull()).containsEntry((Object)"YES", (Object)1)).containsEntry((Object)"MAYBE", (Object)2)).containsEntry((Object)"NO", (Object)3);
    }

    @Test
    void testAnswerWithVariableInfoProtoFile() {
        AbstractProtoGenerator generator = (AbstractProtoGenerator)this.protoGeneratorBuilder().build(Collections.emptyList());
        Proto proto = generator.generate("@Indexed", "@Field(index = Index.NO, store = Store.YES) @SortableField", "org.kie.kogito.test.persons", this.convertToType(Answer.class), new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test.persons");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getEnums()).hasSize(1);
        ProtoEnum answer = (ProtoEnum)proto.getEnums().get(0);
        Assertions.assertThat((Object)answer).isNotNull();
        Assertions.assertThat((String)answer.getName()).isEqualTo("Answer");
        Assertions.assertThat((String)answer.getComment()).isBlank();
        Assertions.assertThat((String)answer.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((Map)answer.getFields()).hasSize(3);
        Map fields = answer.getFields();
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)fields).isNotNull()).containsEntry((Object)"YES", (Object)2)).containsEntry((Object)"MAYBE", (Object)0)).containsEntry((Object)"NO", (Object)1);
    }

    @Test
    void testQuestionWithEnumProtoFile() {
        AbstractProtoGenerator generator = (AbstractProtoGenerator)this.protoGeneratorBuilder().withDataClasses(Collections.singleton(this.convertToType(Question.class))).build(null);
        Proto proto = generator.protoOfDataClasses("org.kie.kogito.test.persons", new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test.persons");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        ProtoMessage question = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)question).isNotNull();
        Assertions.assertThat((String)question.getName()).isEqualTo("Question");
        Assertions.assertThat((String)question.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)question.getFields()).hasSize(2);
        ProtoField field = (ProtoField)question.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("answer");
        Assertions.assertThat((String)field.getType()).isEqualTo("Answer");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)question.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("question");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
    }

    @Test
    void testQuestionWithAnnotatedEnumProtoFile() {
        AbstractProtoGenerator generator = (AbstractProtoGenerator)this.protoGeneratorBuilder().withDataClasses(Collections.singleton(this.convertToType(QuestionWithAnnotatedEnum.class))).build(null);
        Proto proto = generator.protoOfDataClasses("org.kie.kogito.test.persons", new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test.persons");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        ProtoMessage question = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)question).isNotNull();
        Assertions.assertThat((String)question.getName()).isEqualTo(QuestionWithAnnotatedEnum.class.getSimpleName());
        Assertions.assertThat((String)question.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)question.getFields()).hasSize(2);
        ProtoField field = (ProtoField)question.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("answer");
        Assertions.assertThat((String)field.getType()).isEqualTo(AnswerWithAnnotations.class.getSimpleName());
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)question.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("question");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
    }

    @Test
    void checkGeneratedProtoBufAndListing() throws IOException {
        AbstractProtoGenerator generator = (AbstractProtoGenerator)this.protoGeneratorBuilder().build(null);
        ArrayList<GeneratedFile> generatedFiles = new ArrayList<GeneratedFile>();
        for (int i = 0; i < 5; ++i) {
            Proto proto = new Proto("org.acme.test", new String[0]);
            generatedFiles.add(generator.generateProtoFiles("protofile." + i, proto));
        }
        generator.generateProtoListingFile(generatedFiles).ifPresent(generatedFiles::add);
        GeneratedFile listFile = generatedFiles.stream().filter(x -> x.relativePath().endsWith("list.json")).findFirst().get();
        byte[] list = listFile.contents();
        ObjectMapper mapper = new ObjectMapper();
        List files = (List)mapper.readValue(list, List.class);
        Assertions.assertThat((List)files).isNotEmpty();
        ((ListAssert)((ListAssert)Assertions.assertThat((List)files).hasAtLeastOneElementOfType(String.class)).contains((Object[])new String[]{"protofile.0.proto"})).hasSize(5);
    }

    @Test
    void builderTest() {
        T generatedPojo = this.convertToType(GeneratedPOJO.class);
        T address = this.convertToType(Address.class);
        T person = this.convertToType(Person.class);
        AbstractProtoGenerator emptyGenerator = (AbstractProtoGenerator)this.protoGeneratorBuilder().build(null);
        Assertions.assertThat((Object)emptyGenerator.getPersistenceClass()).isNull();
        Assertions.assertThat((Collection)emptyGenerator.getDataClasses()).isEmpty();
        Assertions.assertThat((Collection)emptyGenerator.getModelClasses()).isEmpty();
        AbstractProtoGenerator persistenceClassGenerator = (AbstractProtoGenerator)this.protoGeneratorBuilder().withPersistenceClass(person).build(null);
        Assertions.assertThat((Object)persistenceClassGenerator.getPersistenceClass()).isEqualTo(person);
        Assertions.assertThat((Collection)persistenceClassGenerator.getDataClasses()).isEmpty();
        Assertions.assertThat((Collection)persistenceClassGenerator.getModelClasses()).isEmpty();
        AbstractProtoGenerator dataClassGenerator = (AbstractProtoGenerator)this.protoGeneratorBuilder().withDataClasses(Collections.singleton(person)).build(null);
        Assertions.assertThat((Object)dataClassGenerator.getPersistenceClass()).isNull();
        Assertions.assertThat((Collection)dataClassGenerator.getDataClasses()).hasSize(1);
        Assertions.assertThat((Collection)dataClassGenerator.getModelClasses()).isEmpty();
        AbstractProtoGenerator modelClassGenerator = (AbstractProtoGenerator)this.protoGeneratorBuilder().build(Collections.singleton(generatedPojo));
        Assertions.assertThat((Object)modelClassGenerator.getPersistenceClass()).isNull();
        Assertions.assertThat((Collection)modelClassGenerator.getDataClasses()).hasSize(1);
        Assertions.assertThat((Collection)modelClassGenerator.getModelClasses()).hasSize(1);
        AbstractProtoGenerator dataClassAndModelClassGenerator = (AbstractProtoGenerator)this.protoGeneratorBuilder().withDataClasses(Arrays.asList(person, address)).build(Collections.singleton(generatedPojo));
        Assertions.assertThat((Object)dataClassAndModelClassGenerator.getPersistenceClass()).isNull();
        Assertions.assertThat((Collection)dataClassAndModelClassGenerator.getDataClasses()).hasSize(2);
        Assertions.assertThat((Collection)dataClassAndModelClassGenerator.getModelClasses()).hasSize(1);
    }

    @Test
    void persistenceClassParams() {
        AbstractProtoGenerator noPersistenceClassGenerator = (AbstractProtoGenerator)this.protoGeneratorBuilder().withPersistenceClass(null).build(null);
        Assertions.assertThat((Collection)noPersistenceClassGenerator.getPersistenceClassParams()).isEmpty();
        AbstractProtoGenerator emptyGenerator = (AbstractProtoGenerator)this.protoGeneratorBuilder().withPersistenceClass(this.convertToType(EmptyConstructor.class)).build(null);
        Assertions.assertThat((Collection)emptyGenerator.getPersistenceClassParams()).isEmpty();
        AbstractProtoGenerator notEmptyGenerator = (AbstractProtoGenerator)this.protoGeneratorBuilder().withPersistenceClass(this.convertToType(NotEmptyConstructor.class)).build(null);
        Collection notEmptyClassParams = notEmptyGenerator.getPersistenceClassParams();
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)notEmptyClassParams).isNotEmpty()).hasSize(2)).isEqualTo(Arrays.asList(String.class.getCanonicalName(), Integer.TYPE.getCanonicalName()));
    }

    @Test
    void testProtoOfDataClasses() {
        ArrayList<T> dataClasses = new ArrayList<T>();
        dataClasses.add(this.convertToType(Answer.class));
        dataClasses.add(this.convertToType(Address.class));
        AbstractProtoGenerator generator = (AbstractProtoGenerator)this.protoGeneratorBuilder().withDataClasses(dataClasses).build(null);
        Proto proto = generator.protoOfDataClasses("com.acme", new String[0]);
        Assertions.assertThat((List)proto.getEnums()).hasSize(1);
        Assertions.assertThat((String)((ProtoEnum)proto.getEnums().get(0)).getName()).isEqualTo(Answer.class.getSimpleName());
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        Assertions.assertThat((String)((ProtoMessage)proto.getMessages().get(0)).getName()).isEqualTo(Address.class.getSimpleName());
    }

    @Test
    void recursiveProto() {
        AbstractProtoGenerator generator = (AbstractProtoGenerator)this.protoGeneratorBuilder().withDataClasses(Collections.singleton(this.convertToType(Person.class))).build(null);
        Proto proto = generator.protoOfDataClasses("defaultPkg", new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
    }

    @Test
    void fieldFromClassHierarchy() {
        AbstractProtoGenerator generator = (AbstractProtoGenerator)this.protoGeneratorBuilder().withDataClasses(Arrays.asList(this.convertToType(Person.class), this.convertToType(PersonSubClass.class))).build(null);
        Proto proto = generator.protoOfDataClasses("org.kie.kogito.test.persons", new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test.persons");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(2);
        ProtoMessage person = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getName()).isEqualTo("Person");
        Assertions.assertThat((String)person.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)person.getFields()).hasSize(5);
        ProtoMessage personSubClass = (ProtoMessage)proto.getMessages().get(1);
        Assertions.assertThat((Object)personSubClass).isNotNull();
        Assertions.assertThat((String)personSubClass.getName()).isEqualTo("PersonSubClass");
        Assertions.assertThat((String)personSubClass.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)personSubClass.getFields()).hasSize(6);
        this.assertClassIsIncludedInSubclass(person, personSubClass);
    }

    private void assertClassIsIncludedInSubclass(ProtoMessage superClass, ProtoMessage subClass) {
        for (ProtoField field : superClass.getFields()) {
            Assertions.assertThat((Object)field).isNotNull();
            boolean found = false;
            for (ProtoField subClassField : subClass.getFields()) {
                Assertions.assertThat((Object)subClassField).isNotNull();
                if (!field.getName().equals(subClassField.getName())) continue;
                Assertions.assertThat((String)field.getType()).isEqualTo(subClassField.getType());
                found = true;
                break;
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)found).withFailMessage("Impossible to find field " + field.getName() + " in subclass", new Object[0])).isTrue();
        }
    }
}

