/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.victools.jsonschema.generator.SchemaVersion;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jbpm.util.JsonSchemaUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.ProcessInput;
import org.kie.kogito.UserTask;
import org.kie.kogito.UserTaskParam;
import org.kie.kogito.codegen.VariableInfo;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.json.JsonSchemaGenerator;

public class JsonSchemaGeneratorTest {
    private static final String ALL_OF = "allOf";
    private static final String REF = "$ref";
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";

    @Test
    public void testJsonSchemaGenerator() throws IOException {
        Collection files = new JsonSchemaGenerator.ClassBuilder(Stream.of(EmptyProcessInputModel.class, PersonInputParams.class, ProcessInputModel.class, PersonOutputParams.class, IgnoredClass.class)).build().generate();
        Assertions.assertEquals((int)3, (int)files.size());
        Iterator iterator = files.iterator();
        this.assertEmptyProcessSchema("emptyProcessName.json", (GeneratedFile)iterator.next(), SchemaVersion.DRAFT_2019_09);
        this.assertProcessSchema("processName.json", (GeneratedFile)iterator.next(), SchemaVersion.DRAFT_2019_09);
        this.assertTaskSchema("org#jbpm#test_test.json", (GeneratedFile)iterator.next(), SchemaVersion.DRAFT_2019_09, Arrays.asList("name", "address", "color"), Arrays.asList("name", "address", "age"));
    }

    @Test
    public void testJsonSchemaGeneratorNonExistingDraft() throws IOException {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            JsonSchemaGenerator.ClassBuilder builder = new JsonSchemaGenerator.ClassBuilder(Stream.of(PersonInputParams.class, PersonOutputParams.class, IgnoredClass.class)).withSchemaNameFunction(c -> "pepe").withSchemaVersion("NON_EXISTING_DRAFT");
            builder.build().generate();
        });
    }

    @Test
    public void testJsonSchemaGeneratorDraft7() throws IOException {
        Collection files = new JsonSchemaGenerator.ClassBuilder(Stream.of(EmptyProcessInputModel.class, PersonInputParams.class, ProcessInputModel.class, PersonOutputParams.class, IgnoredClass.class)).withSchemaVersion("DRAFT_7").build().generate();
        Assertions.assertEquals((int)3, (int)files.size());
        Iterator iterator = files.iterator();
        this.assertEmptyProcessSchema("emptyProcessName.json", (GeneratedFile)iterator.next(), SchemaVersion.DRAFT_7);
        this.assertProcessSchema("processName.json", (GeneratedFile)iterator.next(), SchemaVersion.DRAFT_7);
        this.assertTaskSchema("org#jbpm#test_test.json", (GeneratedFile)iterator.next(), SchemaVersion.DRAFT_7, Arrays.asList("name", "address", "color"), Arrays.asList("name", "address", "age"));
    }

    @Test
    public void testJsonSchemaGeneratorInputOutput() throws IOException {
        Collection files = new JsonSchemaGenerator.ClassBuilder(Stream.of(PersonInputOutputParams.class)).build().generate();
        Assertions.assertEquals((int)1, (int)files.size());
        GeneratedFile file = (GeneratedFile)files.iterator().next();
        this.assertTaskSchema("InputOutput_test.json", file, SchemaVersion.DRAFT_2019_09, Arrays.asList("name", "address", "color"), List.of("age"));
    }

    @Test
    public void testJsonSchemaGeneratorWithSpace() throws IOException {
        Collection files = new JsonSchemaGenerator.ClassBuilder(Stream.of(WhitespacesTask.class)).build().generate();
        Assertions.assertEquals((int)1, (int)files.size());
        GeneratedFile file = (GeneratedFile)files.iterator().next();
        Assertions.assertEquals((Object)JsonSchemaUtil.getJsonDir().resolve("InputOutput_name_with_spaces.json").toString(), (Object)file.relativePath());
    }

    @Test
    public void testNothingToDo() throws IOException {
        Collection files = new JsonSchemaGenerator.ClassBuilder(Stream.of(IgnoredClass.class)).build().generate();
        Assertions.assertTrue((boolean)files.isEmpty());
    }

    @Test
    public void testJsonSchemaGenerationForProcess() throws IOException {
        Collection files = new JsonSchemaGenerator.ClassBuilder(Stream.of(ProcessInputModel.class)).build().generate();
        Assertions.assertEquals((int)1, (int)files.size());
        this.assertProcessSchema("processName.json", (GeneratedFile)files.iterator().next(), SchemaVersion.DRAFT_2019_09);
    }

    @Test
    public void testJsonSchemaGenerationForEmptyProcessModel() throws IOException {
        Collection files = new JsonSchemaGenerator.ClassBuilder(Stream.of(EmptyProcessInputModel.class)).build().generate();
        Assertions.assertEquals((int)1, (int)files.size());
        this.assertEmptyProcessSchema("emptyProcessName.json", (GeneratedFile)files.iterator().next(), SchemaVersion.DRAFT_2019_09);
    }

    private void assertEmptyProcessSchema(String fileName, GeneratedFile file, SchemaVersion schemaVersion) throws IOException {
        Assertions.assertEquals((Object)JsonSchemaUtil.getJsonDir().resolve(fileName).toString(), (Object)file.relativePath());
        ObjectReader reader = new ObjectMapper().reader();
        JsonNode node = reader.readTree(file.contents());
        Assertions.assertEquals((Object)schemaVersion.getIdentifier(), (Object)node.get("$schema").asText());
        Assertions.assertEquals((Object)"object", (Object)node.get("type").asText());
        Assertions.assertNull((Object)node.get("properties"));
    }

    private void assertProcessSchema(String fileName, GeneratedFile file, SchemaVersion schemaVersion) throws IOException {
        Assertions.assertEquals((Object)JsonSchemaUtil.getJsonDir().resolve(fileName).toString(), (Object)file.relativePath());
        ObjectReader reader = new ObjectMapper().reader();
        JsonNode node = reader.readTree(file.contents());
        Assertions.assertEquals((Object)schemaVersion.getIdentifier(), (Object)node.get("$schema").asText());
        String definitionsPath = this.resolveDefinitionsProperty(schemaVersion);
        Assertions.assertEquals((int)3, (int)node.get(definitionsPath).size());
        this.assertPersonNode(node.get(definitionsPath).get("Person"), definitionsPath);
        this.assertAddressNode(node.get(definitionsPath).get("Address"));
        this.assertColorNode(node.get(definitionsPath).get("Color"));
        Assertions.assertEquals((Object)"object", (Object)node.get("type").asText());
        JsonNode properties = node.get("properties");
        Assertions.assertEquals((int)2, (int)properties.size());
        JsonNode color = properties.get("color");
        Assertions.assertEquals((Object)("#/" + definitionsPath + "/Color"), (Object)color.get(REF).asText());
        JsonNode address = properties.get("person");
        Assertions.assertEquals((Object)("#/" + definitionsPath + "/Person"), (Object)address.get(REF).asText());
    }

    private void assertTaskSchema(String fileName, GeneratedFile file, SchemaVersion schemaVersion, List<String> inputs, List<String> outputs) throws IOException {
        Assertions.assertEquals((Object)JsonSchemaUtil.getJsonDir().resolve(fileName).toString(), (Object)file.relativePath());
        ObjectReader reader = new ObjectMapper().reader();
        JsonNode node = reader.readTree(file.contents());
        Assertions.assertEquals((Object)schemaVersion.getIdentifier(), (Object)node.get("$schema").asText());
        String definitionsPath = this.resolveDefinitionsProperty(schemaVersion);
        Assertions.assertEquals((int)2, (int)node.get(definitionsPath).size());
        this.assertAddressNode(node.get(definitionsPath).get("Address"));
        this.assertColorNode(node.get(definitionsPath).get("Color"));
        Assertions.assertEquals((Object)"object", (Object)node.get("type").asText());
        JsonNode properties = node.get("properties");
        Assertions.assertEquals((int)4, (int)properties.size());
        this.assertBasicTaskField(properties, "age", "integer", inputs, outputs);
        this.assertBasicTaskField(properties, "name", "string", inputs, outputs);
        this.assertTaskFieldWithRef(properties, "color", "#/" + definitionsPath + "/Color", inputs, outputs);
        this.assertTaskFieldWithRef(properties, "address", "#/" + definitionsPath + "/Address", inputs, outputs);
    }

    private void assertBasicTaskField(JsonNode properties, String name, String type, List<String> inputs, List<String> outputs) {
        JsonNode property = properties.get(name);
        Assertions.assertEquals((Object)type, (Object)property.get("type").asText());
        if (inputs.contains(name)) {
            this.checkNodeHasInputField(property);
        }
        if (outputs.contains(name)) {
            this.checkNodeHasOutputField(property);
        }
    }

    private void checkNodeHasInputField(JsonNode node) {
        Assertions.assertTrue((boolean)node.has(INPUT));
        Assertions.assertTrue((boolean)node.get(INPUT).asBoolean());
    }

    private void checkNodeHasOutputField(JsonNode node) {
        Assertions.assertTrue((boolean)node.has(OUTPUT));
        Assertions.assertTrue((boolean)node.get(OUTPUT).asBoolean());
    }

    private void assertChildAssignmentNode(ArrayNode arrayNode, String assignment) {
        Iterable iterable = () -> arrayNode.iterator();
        JsonNode childAssignment = StreamSupport.stream(iterable.spliterator(), false).filter(node -> node.has(assignment)).findFirst().orElse(null);
        Assertions.assertNotNull((Object)childAssignment);
        Assertions.assertTrue((boolean)childAssignment.get(assignment).asBoolean());
    }

    private void assertTaskFieldWithRef(JsonNode properties, String name, String refPath, List<String> inputs, List<String> outputs) {
        JsonNode property = properties.get(name);
        if (property.has(ALL_OF)) {
            ArrayNode allOf = (ArrayNode)property.get(ALL_OF);
            Assertions.assertEquals((Object)refPath, (Object)allOf.get(0).get(REF).asText());
            if (inputs.contains(name)) {
                this.assertChildAssignmentNode(allOf, INPUT);
            }
            if (outputs.contains(name)) {
                this.assertChildAssignmentNode(allOf, OUTPUT);
            }
        } else {
            Assertions.assertEquals((Object)refPath, (Object)property.get(REF).asText());
            if (inputs.contains(name)) {
                this.checkNodeHasInputField(property);
            }
            if (outputs.contains(name)) {
                this.checkNodeHasOutputField(property);
            }
        }
    }

    private void assertPersonNode(JsonNode personNode, String definitionsPath) {
        Assertions.assertNotNull((Object)personNode);
        Assertions.assertEquals((Object)"object", (Object)personNode.get("type").asText());
        JsonNode personProperties = personNode.get("properties");
        Assertions.assertEquals((Object)"string", (Object)personProperties.get("name").get("type").asText());
        Assertions.assertEquals((Object)"integer", (Object)personProperties.get("age").get("type").asText());
        Assertions.assertEquals((Object)("#/" + definitionsPath + "/Address"), (Object)personProperties.get("address").get(REF).asText());
        Assertions.assertEquals((Object)("#/" + definitionsPath + "/Person"), (Object)personProperties.get("parent").get(REF).asText());
    }

    private void assertAddressNode(JsonNode addressNode) {
        Assertions.assertNotNull((Object)addressNode);
        Assertions.assertEquals((Object)"object", (Object)addressNode.get("type").asText());
        JsonNode addressProperties = addressNode.get("properties");
        Assertions.assertEquals((Object)"string", (Object)addressProperties.get("street").get("type").asText());
        JsonNode dateNode = addressProperties.get("date");
        Assertions.assertEquals((Object)"string", (Object)dateNode.get("type").asText());
        Assertions.assertEquals((Object)"date-time", (Object)dateNode.get("format").asText());
    }

    private void assertColorNode(JsonNode colorNode) {
        Assertions.assertNotNull((Object)colorNode);
        Assertions.assertEquals((Object)"string", (Object)colorNode.get("type").asText());
        Assertions.assertTrue((boolean)(colorNode.get("enum") instanceof ArrayNode));
        ArrayNode colors = (ArrayNode)colorNode.get("enum");
        EnumSet<Color> colorValues = EnumSet.noneOf(Color.class);
        colors.forEach(x -> colorValues.add(Color.valueOf(x.asText())));
        Assertions.assertArrayEquals((Object[])Color.values(), (Object[])colorValues.toArray());
    }

    private String resolveDefinitionsProperty(SchemaVersion schemaVersion) {
        return SchemaVersion.DRAFT_2019_09.equals((Object)schemaVersion) ? "$defs" : "definitions";
    }

    private static class IgnoredClass {
        @UserTaskParam(value=UserTaskParam.ParamType.OUTPUT)
        private int age;

        private IgnoredClass() {
        }
    }

    private static class Address {
        private String street;
        private Date date;

        private Address() {
        }
    }

    private static class Person {
        private String name;
        private int age;
        private Address address;
        private Person parent;

        private Person() {
        }
    }

    @ProcessInput(processName="emptyProcessName")
    private static class EmptyProcessInputModel {
        private Color color;
        private Person person;

        private EmptyProcessInputModel() {
        }
    }

    @ProcessInput(processName="processName")
    private static class ProcessInputModel {
        @VariableInfo
        private Color color;
        @VariableInfo
        private Person person;

        private ProcessInputModel() {
        }
    }

    @UserTask(taskName="name with spaces", processName="InputOutput")
    private static class WhitespacesTask {
        @UserTaskParam(value=UserTaskParam.ParamType.OUTPUT)
        private int age;
        @UserTaskParam(value=UserTaskParam.ParamType.INPUT)
        private String name;

        private WhitespacesTask() {
        }
    }

    @UserTask(taskName="test", processName="InputOutput")
    private static class PersonInputOutputParams {
        @UserTaskParam(value=UserTaskParam.ParamType.OUTPUT)
        private int age;
        @UserTaskParam(value=UserTaskParam.ParamType.INPUT)
        private String name;
        @UserTaskParam(value=UserTaskParam.ParamType.INPUT)
        private Address address;
        @UserTaskParam(value=UserTaskParam.ParamType.INPUT)
        private Color color;

        private PersonInputOutputParams() {
        }
    }

    @UserTask(taskName="test", processName="org.jbpm.test")
    private static class PersonOutputParams {
        @UserTaskParam(value=UserTaskParam.ParamType.OUTPUT)
        private int age;
        @UserTaskParam(value=UserTaskParam.ParamType.OUTPUT)
        private String name;
        @UserTaskParam(value=UserTaskParam.ParamType.OUTPUT)
        private Address address;
        private String ignored;

        private PersonOutputParams() {
        }
    }

    @UserTask(taskName="test", processName="org.jbpm.test")
    private static class PersonInputParams {
        @UserTaskParam(value=UserTaskParam.ParamType.INPUT)
        private String name;
        @UserTaskParam(value=UserTaskParam.ParamType.INPUT)
        private Address address;
        @UserTaskParam(value=UserTaskParam.ParamType.INPUT)
        private Color color;

        private PersonInputParams() {
        }
    }

    private static enum Color {
        GREEN,
        WHITE;

    }
}

