/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.persistence;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.codegen.api.AddonsConfig;
import org.kie.kogito.codegen.api.GeneratedFileType;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.utils.KogitoContextTestUtils;
import org.kie.kogito.codegen.data.GeneratedPOJO;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ReflectionProtoGenerator;

public abstract class AbstractPersistenceGeneratorTest {
    protected static final String TEST_RESOURCES = "src/test/resources";

    protected abstract String persistenceType();

    public static Stream<Arguments> persistenceTestContexts() {
        return KogitoContextTestUtils.contextBuilders().map(args -> args.get()[0]).map(KogitoBuildContext.Builder.class::cast).map(contextBuilder -> contextBuilder.withApplicationProperties(new File[]{new File(TEST_RESOURCES)}).withPackageName(AbstractPersistenceGeneratorTest.class.getPackage().getName()).withAddonsConfig(AddonsConfig.builder().withPersistence(true).build())).flatMap(AbstractPersistenceGeneratorTest::initDifferentOptions).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private static Stream<KogitoBuildContext> initDifferentOptions(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext allOptionsContext = contextBuilder.build();
        allOptionsContext.setApplicationProperty("kogito.persistence.data-index.proto.generation", "true");
        allOptionsContext.setApplicationProperty("kogito.persistence.proto.marshaller", "true");
        KogitoBuildContext noDataIndexContext = contextBuilder.build();
        noDataIndexContext.setApplicationProperty("kogito.persistence.data-index.proto.generation", "false");
        noDataIndexContext.setApplicationProperty("kogito.persistence.proto.marshaller", "true");
        KogitoBuildContext noMarshallerContext = contextBuilder.build();
        noMarshallerContext.setApplicationProperty("kogito.persistence.data-index.proto.generation", "true");
        noMarshallerContext.setApplicationProperty("kogito.persistence.proto.marshaller", "false");
        KogitoBuildContext noOptionsContext = contextBuilder.build();
        noOptionsContext.setApplicationProperty("kogito.persistence.data-index.proto.generation", "false");
        noOptionsContext.setApplicationProperty("kogito.persistence.proto.marshaller", "false");
        return Stream.of(allOptionsContext, noDataIndexContext, noMarshallerContext, noOptionsContext);
    }

    @ParameterizedTest
    @MethodSource(value={"persistenceTestContexts"})
    void persistenceGeneratorSanityCheck(KogitoBuildContext context) {
        context.setApplicationProperty("kogito.persistence.type", this.persistenceType());
        ReflectionProtoGenerator protoGenerator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().build(Collections.singleton(GeneratedPOJO.class));
        PersistenceGenerator persistenceGenerator = new PersistenceGenerator(context, (ProtoGenerator)protoGenerator);
        Collection generatedFiles = persistenceGenerator.generate();
        int expectedDataIndexProto = PersistenceGenerator.hasDataIndexProto((KogitoBuildContext)context) ? 2 : 0;
        int expectedListDataIndexProto = PersistenceGenerator.hasDataIndexProto((KogitoBuildContext)context) ? 1 : 0;
        Assertions.assertThat((long)generatedFiles.stream().filter(gf -> gf.type().equals(ProtoGenerator.PROTO_TYPE)).count()).isEqualTo((long)expectedDataIndexProto);
        Assertions.assertThat((long)generatedFiles.stream().filter(gf -> gf.type().equals(ProtoGenerator.PROTO_TYPE) && gf.relativePath().endsWith(".json")).count()).isEqualTo((long)expectedListDataIndexProto);
        int expectedProtoMarshaller = PersistenceGenerator.hasProtoMarshaller((KogitoBuildContext)context) ? 10 : 0;
        Assertions.assertThat(generatedFiles.stream().filter(gf -> gf.type().equals(GeneratedFileType.SOURCE) && gf.relativePath().endsWith("Marshaller.java"))).hasSize(expectedProtoMarshaller);
    }
}

