/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.json.JsonUtils;

public class JsonUtilsTest {
    @Test
    public void testFullMerge() {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node1 = this.createJson(mapper, this.createJson(mapper, "numbers", Arrays.asList(1, 2, 3)));
        JsonNode node2 = this.createJson(mapper, this.createJson(mapper, "numbers", Arrays.asList(4, 5, 6)));
        JsonNode node3 = this.createJson(mapper, (JsonNode)mapper.createObjectNode().put("number", 1));
        JsonNode node4 = this.createJson(mapper, (JsonNode)mapper.createObjectNode().put("boolean", false));
        JsonNode node5 = this.createJson(mapper, (JsonNode)mapper.createObjectNode().put("string", "javier"));
        ObjectNode result = mapper.createObjectNode();
        JsonUtils.merge((JsonNode)node1, (JsonNode)result);
        JsonUtils.merge((JsonNode)node2, (JsonNode)result);
        JsonUtils.merge((JsonNode)node3, (JsonNode)result);
        JsonUtils.merge((JsonNode)node4, (JsonNode)result);
        JsonUtils.merge((JsonNode)node5, (JsonNode)result);
        Assertions.assertEquals((int)1, (int)result.size());
        JsonNode merged = result.get("merged");
        Assertions.assertEquals((int)4, (int)merged.size());
        JsonNode numbers = merged.get("numbers");
        Assertions.assertTrue((boolean)(numbers instanceof ArrayNode));
        ArrayNode numbersNode = (ArrayNode)numbers;
        Assertions.assertEquals((int)6, (int)numbersNode.size());
        Assertions.assertEquals((int)1, (int)numbersNode.get(0).asInt());
        Assertions.assertEquals((int)2, (int)numbersNode.get(1).asInt());
        Assertions.assertEquals((int)3, (int)numbersNode.get(2).asInt());
        Assertions.assertEquals((int)4, (int)numbersNode.get(3).asInt());
        Assertions.assertEquals((int)5, (int)numbersNode.get(4).asInt());
        Assertions.assertEquals((int)6, (int)numbersNode.get(5).asInt());
        Assertions.assertEquals((Object)false, (Object)merged.get("boolean").asBoolean());
        Assertions.assertEquals((Object)"javier", (Object)merged.get("string").asText());
        Assertions.assertEquals((int)1, (int)merged.get("number").asInt());
    }

    @Test
    public void testArrayIntoObjectMerge() {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode src = this.createJson(mapper, this.createJson(mapper, "property", Arrays.asList(1, 2, 3)));
        JsonNode target = this.createJson(mapper, (JsonNode)mapper.createObjectNode().put("property", 4));
        JsonUtils.merge((JsonNode)src, (JsonNode)target);
        Assertions.assertEquals((int)1, (int)target.size());
        JsonNode merged = target.get("merged");
        Assertions.assertEquals((int)1, (int)merged.size());
        JsonNode property = merged.get("property");
        Assertions.assertTrue((boolean)(property instanceof ArrayNode));
        ArrayNode propertyNode = (ArrayNode)property;
        Assertions.assertEquals((int)4, (int)propertyNode.size());
        Assertions.assertEquals((int)4, (int)propertyNode.get(0).asInt());
        Assertions.assertEquals((int)1, (int)propertyNode.get(1).asInt());
        Assertions.assertEquals((int)2, (int)propertyNode.get(2).asInt());
        Assertions.assertEquals((int)3, (int)propertyNode.get(3).asInt());
    }

    @Test
    public void testArrayIntoNewPropertyMerge() {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode src = this.createJson(mapper, this.createJson(mapper, "property", Arrays.asList(1, 2, 3)));
        JsonNode target = this.createJson(mapper, (JsonNode)mapper.createObjectNode());
        JsonUtils.merge((JsonNode)src, (JsonNode)target);
        Assertions.assertEquals((int)1, (int)target.size());
        JsonNode merged = target.get("merged");
        Assertions.assertEquals((int)1, (int)merged.size());
        JsonNode property = merged.get("property");
        Assertions.assertTrue((boolean)(property instanceof ArrayNode));
        ArrayNode propertyNode = (ArrayNode)property;
        Assertions.assertEquals((int)3, (int)propertyNode.size());
        Assertions.assertEquals((int)1, (int)propertyNode.get(0).asInt());
        Assertions.assertEquals((int)2, (int)propertyNode.get(1).asInt());
        Assertions.assertEquals((int)3, (int)propertyNode.get(2).asInt());
    }

    private JsonNode createJson(ObjectMapper mapper, String name, Collection<Integer> integers) {
        ArrayNode node = mapper.createArrayNode();
        for (int i : integers) {
            node.add(i);
        }
        return mapper.createObjectNode().set(name, (JsonNode)node);
    }

    private JsonNode createJson(ObjectMapper mapper, JsonNode node) {
        return mapper.createObjectNode().set("merged", node);
    }
}

