/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.events;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.api.AddonsConfig;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.JavaKogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.api.template.TemplatedGenerator;
import org.kie.kogito.codegen.core.events.AbstractCloudEventMetaFactoryGenerator;
import org.kie.kogito.codegen.process.ProcessExecutableModelGenerator;
import org.kie.kogito.codegen.process.ProcessGenerationUtils;
import org.kie.kogito.codegen.process.events.ProcessCloudEventMetaFactoryGenerator;
import org.kie.kogito.event.EventKind;
import org.kie.kogito.event.cloudevents.CloudEventMeta;

class ProcessCloudEventMetaFactoryGeneratorTest {
    ProcessCloudEventMetaFactoryGeneratorTest() {
    }

    @Test
    void testTemplateIsValid() {
        Optional<ObjectCreationExpr> optObjectCreationExprExpr;
        List returnStmtList;
        TemplatedGenerator generator = AbstractCloudEventMetaFactoryGenerator.buildTemplatedGenerator((KogitoBuildContext)this.getContext(true), (String)"ProcessCloudEventMetaFactory");
        CompilationUnit compilationUnit = generator.compilationUnit().orElseGet(() -> (CompilationUnit)org.junit.jupiter.api.Assertions.fail((String)"Cannot generate ProcessCloudEventMetaFactory"));
        ClassOrInterfaceDeclaration classDefinition = compilationUnit.findFirst(ClassOrInterfaceDeclaration.class).orElseGet(() -> (ClassOrInterfaceDeclaration)org.junit.jupiter.api.Assertions.fail((String)"Compilation unit doesn't contain a class or interface declaration!"));
        MethodDeclaration methodDeclaration = classDefinition.findFirst(MethodDeclaration.class, x -> x.getName().toString().startsWith("buildCloudEventMeta_")).orElseGet(() -> (MethodDeclaration)org.junit.jupiter.api.Assertions.fail((String)"Impossible to find expected buildCloudEventMeta_ method"));
        if (!methodDeclaration.getName().toString().contains("$methodName$")) {
            org.junit.jupiter.api.Assertions.fail((String)"Missing $methodName$ placeholder in templated build method declaration");
        }
        if ((returnStmtList = methodDeclaration.findAll(ReturnStmt.class)).size() != 1) {
            org.junit.jupiter.api.Assertions.fail((String)"Templated build method declaration must contain exactly one return statement");
        }
        if (!(optObjectCreationExprExpr = ((ReturnStmt)returnStmtList.get(0)).getExpression().filter(Expression::isObjectCreationExpr).map(Expression::asObjectCreationExpr).filter(ocExpr -> {
            String typeName = ocExpr.getType().getNameAsString();
            return typeName.equals(CloudEventMeta.class.getSimpleName()) || typeName.equals(CloudEventMeta.class.getName());
        }).filter(ocExpr -> ocExpr.getArguments().size() == 3).filter(ocExpr -> ((Expression)ocExpr.getArguments().get(0)).toString().equals("$type$") && ((Expression)ocExpr.getArguments().get(1)).toString().equals("$source$") && ((Expression)ocExpr.getArguments().get(2)).toString().equals("$kind$"))).isPresent()) {
            org.junit.jupiter.api.Assertions.fail((String)"Templated build method declaration return statement must be an ObjectCreationExpr of type CloudEventMeta with three placeholder arguments ($type$, $source$, $kind$)");
        }
    }

    @Test
    void testGetBuilderMethodName() {
        String testSource = "class ProcessCloudEventMetaFactory {\n    public CloudEventMeta buildCloudEventMeta_CONSUMED_first() {\n        return new CloudEventMeta(\"first\", \"\", org.kie.kogito.event.EventKind.CONSUMED);\n    }\n    public CloudEventMeta buildCloudEventMeta_CONSUMED_second() {\n        return new CloudEventMeta(\"second\", \"\", org.kie.kogito.event.EventKind.CONSUMED);\n    }}";
        ClassOrInterfaceDeclaration testClassDefinition = StaticJavaParser.parse((String)testSource).findFirst(ClassOrInterfaceDeclaration.class).orElseGet(() -> (ClassOrInterfaceDeclaration)org.junit.jupiter.api.Assertions.fail((String)"Test source doesn't contain a class or interface declaration!"));
        String templatedBuildMethodName = "buildCloudEventMeta_$methodName$";
        org.junit.jupiter.api.Assertions.assertEquals((Object)"buildCloudEventMeta_PRODUCED_first", (Object)AbstractCloudEventMetaFactoryGenerator.getBuilderMethodName((ClassOrInterfaceDeclaration)testClassDefinition, (String)templatedBuildMethodName, (String)"PRODUCED_first"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"buildCloudEventMeta_CONSUMED_first_1", (Object)AbstractCloudEventMetaFactoryGenerator.getBuilderMethodName((ClassOrInterfaceDeclaration)testClassDefinition, (String)templatedBuildMethodName, (String)"CONSUMED_first"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"buildCloudEventMeta_CONSUMED_third", (Object)AbstractCloudEventMetaFactoryGenerator.getBuilderMethodName((ClassOrInterfaceDeclaration)testClassDefinition, (String)templatedBuildMethodName, (String)"CONSUMED_third"));
    }

    @Test
    void testToValidJavaIdentifier() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"simpleName", (Object)AbstractCloudEventMetaFactoryGenerator.toValidJavaIdentifier((String)"simpleName"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"more_37Com__plex_47Name_33", (Object)AbstractCloudEventMetaFactoryGenerator.toValidJavaIdentifier((String)"more%Com_plex/Name!"));
    }

    @Test
    void verifyProcessWithMessageEvent() {
        ClassOrInterfaceDeclaration clazz = this.generateAndParseClass("/messageevent/IntermediateCatchEventMessage.bpmn2", 1, true);
        Assertions.assertThat((Object)clazz).isNotNull();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)clazz.getMethods().size());
        this.assertReturnExpressionContains((MethodDeclaration)clazz.getMethods().get(0), "customers", EventKind.CONSUMED);
    }

    @Test
    void verifyProcessWithStartAndEndMessageEvent() {
        ClassOrInterfaceDeclaration clazz = this.generateAndParseClass("/messagestartevent/MessageStartAndEndEvent.bpmn2", 2, true);
        Assertions.assertThat((Object)clazz).isNotNull();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)clazz.getMethods().size());
        List methods = clazz.getMethods().stream().sorted(Comparator.comparing(NodeWithSimpleName::getNameAsString)).collect(Collectors.toList());
        this.assertReturnExpressionContains((MethodDeclaration)methods.get(0), "customers", EventKind.CONSUMED);
        this.assertReturnExpressionContains((MethodDeclaration)methods.get(1), "process.messagestartevent.processedcustomers", EventKind.PRODUCED);
    }

    @Test
    void verifyProcessWithIntermediateThrowEventMessageEvent() {
        ClassOrInterfaceDeclaration clazz = this.generateAndParseClass("/messageevent/IntermediateThrowEventMessage.bpmn2", 1, true);
        Assertions.assertThat((Object)clazz).isNotNull();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)clazz.getMethods().size());
        this.assertReturnExpressionContains((MethodDeclaration)clazz.getMethods().get(0), "process.messageintermediateevent.customers", EventKind.PRODUCED);
    }

    @Test
    void verifyProcessWithBoundaryEventMessageEvent() {
        ClassOrInterfaceDeclaration clazz = this.generateAndParseClass("/messageevent/BoundaryMessageEventOnTask.bpmn2", 1, true);
        Assertions.assertThat((Object)clazz).isNotNull();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)clazz.getMethods().size());
        this.assertReturnExpressionContains((MethodDeclaration)clazz.getMethods().get(0), "customers", EventKind.CONSUMED);
    }

    @Test
    void verifyProcessWithoutMessageEvent() {
        ClassOrInterfaceDeclaration clazz = this.generateAndParseClass("/usertask/approval.bpmn2", 0, true);
        Assertions.assertThat((Object)clazz).isNotNull();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)clazz.getMethods().isEmpty());
    }

    private void assertReturnExpressionContains(MethodDeclaration method, String expectedType, EventKind expectedKind) {
        Optional<String> optExpr = method.getBody().map(BlockStmt::getStatements).filter(stmtList -> stmtList.size() == 1).map(stmtList -> (Statement)stmtList.get(0)).filter(Statement::isReturnStmt).map(Statement::asReturnStmt).flatMap(ReturnStmt::getExpression).map(Node::toString);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)optExpr.filter(str -> str.contains(String.format("\"%s\"", expectedType))).isPresent(), () -> String.format("Method %s doesn't contain \"%s\" as event type", method.getName(), expectedType));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)optExpr.filter(str -> str.contains(String.format("%s.%s", EventKind.class.getName(), expectedKind.name()))).isPresent(), () -> String.format("Method %s doesn't contain %s as event kind", method.getName(), expectedKind.name()));
    }

    private ClassOrInterfaceDeclaration generateAndParseClass(String bpmnFile, int expectedTriggers, boolean withInjection) {
        KogitoBuildContext context = this.getContext(withInjection);
        List<ProcessExecutableModelGenerator> execModelGenerators = ProcessGenerationUtils.execModelFromProcessFile(bpmnFile);
        ProcessCloudEventMetaFactoryGenerator generator = new ProcessCloudEventMetaFactoryGenerator(context, execModelGenerators);
        Set ces = generator.getCloudEventMetaBuilder().build(execModelGenerators);
        if (expectedTriggers > 0) {
            Assertions.assertThat((Collection)ces).isNotEmpty();
            Assertions.assertThat((int)ces.size()).isEqualTo(expectedTriggers);
        } else {
            Assertions.assertThat((Collection)ces).isEmpty();
        }
        String source = generator.generate();
        Assertions.assertThat((String)source).isNotNull();
        ClassOrInterfaceDeclaration clazz = (ClassOrInterfaceDeclaration)StaticJavaParser.parse((String)source).getClassByName(generator.getClassName()).orElseThrow(() -> new IllegalArgumentException("Class does not exists"));
        return clazz;
    }

    private KogitoBuildContext getContext(boolean withInjection) {
        return (withInjection ? QuarkusKogitoBuildContext.builder() : JavaKogitoBuildContext.builder()).withAddonsConfig(AddonsConfig.builder().withCloudEvents(true).build()).build();
    }
}

