/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.svg;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.codegen.api.AddonsConfig;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.GeneratedFileType;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.core.io.CollectedResourceProducer;
import org.kie.kogito.codegen.process.ProcessCodegen;

public class CodegenSvgTest {
    private static final Path BASE_PATH = Paths.get("src/test/resources/svg", new String[0]).toAbsolutePath();
    private static final String TEST_PROCESS_SOURCE = "hiring.bpmn";
    private static final String TEST_PROCESS_GENERATED_SVG_SOURCE = "hiring-svg.svg";
    private static final String TEST_PROCESS_ID = "hiringProcessId";

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void testExportedSVGRenamedAndMoved(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.withAddonsConfig(AddonsConfig.builder().withProcessSVG(true).build()).build();
        Collection collectedResources = CollectedResourceProducer.fromPaths((Path[])new Path[]{BASE_PATH});
        Assertions.assertThat((boolean)collectedResources.stream().anyMatch(f -> f.resource().getSourcePath().endsWith(TEST_PROCESS_SOURCE))).isTrue();
        Assertions.assertThat((boolean)collectedResources.stream().anyMatch(f -> f.resource().getSourcePath().endsWith(TEST_PROCESS_GENERATED_SVG_SOURCE))).isTrue();
        Assertions.assertThat((boolean)collectedResources.stream().anyMatch(f -> f.resource().getSourcePath().endsWith(String.format("%s-svg.svg", "hiring")))).isTrue();
        ProcessCodegen codeGenerator = ProcessCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)collectedResources);
        Collection generatedFiles = codeGenerator.generate();
        Assertions.assertThat((Collection)generatedFiles).isNotEmpty();
        List resources = generatedFiles.stream().filter(generatedFile -> generatedFile.type().equals(GeneratedFileType.INTERNAL_RESOURCE)).collect(Collectors.toList());
        Assertions.assertThat((int)resources.size()).isEqualTo(1);
        Assertions.assertThat((String)"META-INF/processSVG/hiringProcessId.svg").isEqualTo(((GeneratedFile)resources.get(0)).relativePath());
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void testWithoutSVGAddonNoRenamedAndMoved(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.withAddonsConfig(AddonsConfig.builder().withProcessSVG(false).build()).build();
        Collection collectedResources = CollectedResourceProducer.fromPaths((Path[])new Path[]{BASE_PATH});
        Assertions.assertThat((boolean)collectedResources.stream().anyMatch(f -> f.resource().getSourcePath().endsWith(TEST_PROCESS_SOURCE))).isTrue();
        Assertions.assertThat((boolean)collectedResources.stream().anyMatch(f -> f.resource().getSourcePath().endsWith(TEST_PROCESS_GENERATED_SVG_SOURCE))).isTrue();
        ProcessCodegen codeGenerator = ProcessCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)collectedResources);
        Collection generatedFiles = codeGenerator.generate();
        Assertions.assertThat((Collection)generatedFiles).isNotEmpty();
        List resources = generatedFiles.stream().filter(generatedFile -> generatedFile.type().equals(GeneratedFileType.INTERNAL_RESOURCE)).collect(Collectors.toList());
        Assertions.assertThat((int)resources.size()).isZero();
    }

    @Test
    public void TestIsFilenameValid() {
        Assertions.assertThat((boolean)ProcessCodegen.isFilenameValid((String)"processId\u0000.svg")).isFalse();
        Assertions.assertThat((boolean)ProcessCodegen.isFilenameValid((String)"processId.svg")).isTrue();
    }
}

