/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.kie.kogito.codegen.data.Address;
import org.kie.kogito.codegen.data.Money;

public class Person {
    private String id;
    private String name;
    private int age;
    private byte[] bytes;
    private boolean adult;
    private Person parent;
    private Person[] relatives;
    private Instant instant;
    private LocalDateTime localDateTime;
    private LocalDate localDate;
    private Duration duration;
    private ZonedDateTime zonedDateTime;
    private OffsetDateTime offsetDateTime;
    private Date date;
    private BigDecimal bigDecimal;
    @JsonIgnore
    private Money salary;
    private transient String ignoreMe;
    private static String staticallyIgnoreMe;
    private transient List<Address> addresses = new ArrayList<Address>();

    public Person() {
    }

    public Person(String name, int age) {
        this.name = name;
        this.age = age;
        this.salary = Money.of(BigDecimal.valueOf(100L));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public boolean isAdult() {
        return this.adult;
    }

    public void setAdult(boolean adult) {
        this.adult = adult;
    }

    public String getIgnoreMe() {
        return this.ignoreMe;
    }

    public void setIgnoreMe(String ignoreMe) {
        this.ignoreMe = ignoreMe;
    }

    public static String getStaticallyIgnoreMe() {
        return staticallyIgnoreMe;
    }

    public static void setStaticallyIgnoreMe(String staticallyIgnoreMe) {
        Person.staticallyIgnoreMe = staticallyIgnoreMe;
    }

    public void addAddress(Address address) {
        this.addresses.add(address);
    }

    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Person getParent() {
        return this.parent;
    }

    public void setParent(Person parent) {
        this.parent = parent;
    }

    public Instant getInstant() {
        return this.instant;
    }

    public void setInstant(Instant instant) {
        this.instant = instant;
    }

    public LocalDateTime getLocalDateTime() {
        return this.localDateTime;
    }

    public void setLocalDateTime(LocalDateTime localDateTime) {
        this.localDateTime = localDateTime;
    }

    public LocalDate getLocalDate() {
        return this.localDate;
    }

    public void setLocalDate(LocalDate localDate) {
        this.localDate = localDate;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public ZonedDateTime getZonedDateTime() {
        return this.zonedDateTime;
    }

    public void setZonedDateTime(ZonedDateTime zonedDateTime) {
        this.zonedDateTime = zonedDateTime;
    }

    public OffsetDateTime getOffsetDateTime() {
        return this.offsetDateTime;
    }

    public void setOffsetDateTime(OffsetDateTime offsetDateTime) {
        this.offsetDateTime = offsetDateTime;
    }

    public Date getDate() {
        return this.date;
    }

    public BigDecimal getBigDecimal() {
        return this.bigDecimal;
    }

    public void setBigDecimal(BigDecimal bigDecimal) {
        this.bigDecimal = bigDecimal;
    }

    public Money getSalary() {
        return this.salary;
    }

    public void setSalary(Money salary) {
        this.salary = salary;
    }

    public Person[] getRelatives() {
        return this.relatives;
    }

    public void setRelatives(Person[] relatives) {
        this.relatives = relatives;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public String toString() {
        return "Person{id='" + this.id + "', name='" + this.name + "', age=" + this.age + ", adult=" + this.adult + ", parent=" + this.parent + ", relatives=" + Arrays.toString(this.relatives) + ", instant=" + this.instant + ", localDateTime=" + this.localDateTime + ", localDate=" + this.localDate + ", duration=" + this.duration + ", zonedDateTime=" + this.zonedDateTime + ", offsetDateTime=" + this.offsetDateTime + ", date=" + this.date + ", bigDecimal=" + this.bigDecimal + ", salary=" + this.salary + ", ignoreMe='" + this.ignoreMe + "', addresses=" + this.addresses + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Person person = (Person)o;
        return this.age == person.age && this.adult == person.adult && Objects.equals(this.name, person.name) && Objects.equals(this.parent, person.parent) && Objects.equals(this.ignoreMe, person.ignoreMe) && Objects.equals(this.addresses, person.addresses);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.age, this.adult, this.parent, this.ignoreMe, this.addresses);
    }
}

