/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.io.impl.FileSystemResource;
import org.jbpm.compiler.canonical.ProcessToExecModelGenerator;
import org.kie.api.definition.process.Process;
import org.kie.api.io.Resource;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.JavaKogitoBuildContext;
import org.kie.kogito.codegen.process.ProcessCodegen;
import org.kie.kogito.codegen.process.ProcessCodegenException;
import org.kie.kogito.codegen.process.ProcessExecutableModelGenerator;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcess;

public class ProcessGenerationUtils {
    public static List<ProcessExecutableModelGenerator> execModelFromProcessFile(String processFilePath) {
        File processFile = new File(ProcessGenerationUtils.class.getResource(processFilePath).getFile());
        List<Process> processes = ProcessGenerationUtils.parseProcesses(Collections.singleton(processFile));
        Assertions.assertThat(processes).isNotEmpty();
        ProcessToExecModelGenerator execModelGenerator = new ProcessToExecModelGenerator(ProcessGenerationUtils.class.getClassLoader());
        ArrayList<ProcessExecutableModelGenerator> processExecutableModelGenerators = new ArrayList<ProcessExecutableModelGenerator>();
        processes.forEach(p -> processExecutableModelGenerators.add(new ProcessExecutableModelGenerator((KogitoWorkflowProcess)p, execModelGenerator)));
        return processExecutableModelGenerators;
    }

    private static List<Process> parseProcesses(Collection<File> processFiles) {
        ArrayList<Process> processes = new ArrayList<Process>();
        for (File processSourceFile : processFiles) {
            try {
                FileSystemResource r = new FileSystemResource(processSourceFile);
                if (ProcessCodegen.SUPPORTED_BPMN_EXTENSIONS.stream().anyMatch(processSourceFile.getPath()::endsWith)) {
                    processes.addAll(ProcessCodegen.parseProcessFile((Resource)r));
                } else {
                    ProcessCodegen.SUPPORTED_SW_EXTENSIONS.entrySet().stream().filter(e -> processSourceFile.getPath().endsWith((String)e.getKey())).forEach(e -> processes.add((Process)ProcessCodegen.parseWorkflowFile((Resource)r, (String)((String)e.getValue()), (KogitoBuildContext)JavaKogitoBuildContext.builder().build()).info()));
                }
                if (!processes.isEmpty()) continue;
                throw new IllegalArgumentException("Unable to process file with unsupported extension: " + processSourceFile);
            }
            catch (RuntimeException e2) {
                throw new ProcessCodegenException(processSourceFile.getAbsolutePath(), (Throwable)e2);
            }
        }
        return processes;
    }
}

