/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.drools.core.io.impl.FileSystemResource;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.definition.process.Process;
import org.kie.api.io.Resource;
import org.kie.kogito.codegen.api.AddonsConfig;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.process.ProcessCodegen;
import org.kie.kogito.codegen.process.ProcessResourceGenerator;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcess;

class ProcessResourceGeneratorTest {
    private static final List<String> JAVA_AND_QUARKUS_REST_ANNOTATIONS = List.of("DELETE", "GET", "POST");
    private static final List<String> SPRING_BOOT_REST_ANNOTATIONS = List.of("DeleteMapping", "GetMapping", "PostMapping");

    ProcessResourceGeneratorTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void testGenerateProcessWithDocumentation(KogitoBuildContext.Builder contextBuilder) {
        String fileName = "src/test/resources/ProcessWithDocumentation.bpmn";
        String expectedSummary = "This is the documentation";
        String expectedDescription = "This is the process instance description";
        this.testOpenApiDocumentation(contextBuilder, fileName, expectedSummary, expectedDescription);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void testGenerateProcessWithoutDocumentation(KogitoBuildContext.Builder contextBuilder) {
        String fileName = "src/test/resources/ProcessWithoutDocumentation.bpmn";
        String expectedSummary = "ProcessWithoutDocumentation";
        String expectedDescription = "";
        this.testOpenApiDocumentation(contextBuilder, fileName, expectedSummary, expectedDescription);
    }

    void testOpenApiDocumentation(KogitoBuildContext.Builder contextBuilder, String fileName, String expectedSummary, String expectedDescription) {
        ClassOrInterfaceDeclaration classDeclaration = this.getResourceClassDeclaration(contextBuilder, fileName);
        classDeclaration.getMethods().stream().filter(this::isRestMethod).forEach(method -> this.assertThatMethodHasOpenApiDocumentation((MethodDeclaration)method, expectedSummary, expectedDescription));
    }

    private ClassOrInterfaceDeclaration getResourceClassDeclaration(KogitoBuildContext.Builder contextBuilder, String fileName) {
        KogitoWorkflowProcess process = this.parseProcess(fileName);
        CompilationUnit compilationUnit = this.getCompilationUnit(contextBuilder, process);
        Optional classDeclaration = compilationUnit.getClassByName(process.getId() + "Resource");
        Assertions.assertThat((Optional)classDeclaration).isNotEmpty();
        return (ClassOrInterfaceDeclaration)classDeclaration.orElseThrow();
    }

    private CompilationUnit getCompilationUnit(KogitoBuildContext.Builder contextBuilder, KogitoWorkflowProcess process) {
        KogitoBuildContext context = this.createContext(contextBuilder);
        String modelfqcn = "any.Model";
        String processfqcn = "any.Process";
        String appCanonicalName = "AnyApp";
        ProcessResourceGenerator processResourceGenerator = new ProcessResourceGenerator(context, process, modelfqcn, processfqcn, appCanonicalName);
        return StaticJavaParser.parse((String)processResourceGenerator.generate());
    }

    private void assertThatMethodHasOpenApiDocumentation(MethodDeclaration method, String summary, String description) {
        Optional annotation = method.getAnnotationByName("Operation");
        Assertions.assertThat((Optional)annotation).isNotEmpty();
        this.assertThatAnnotationHasSummaryAndDescription((AnnotationExpr)annotation.orElseThrow(), summary, description);
    }

    private void assertThatAnnotationHasSummaryAndDescription(AnnotationExpr annotation, String summary, String description) {
        NodeList pairs = ((NormalAnnotationExpr)annotation).getPairs();
        Assertions.assertThat((List)pairs).containsExactlyInAnyOrder((Object[])new MemberValuePair[]{new MemberValuePair("summary", (Expression)new StringLiteralExpr(summary)), new MemberValuePair("description", (Expression)new StringLiteralExpr(description))});
    }

    private boolean isRestMethod(MethodDeclaration method) {
        return method.getAnnotations().stream().anyMatch(this.isOpenApiAnnotation().or(this.isSwaggerAnnotation()));
    }

    private Predicate<AnnotationExpr> isOpenApiAnnotation() {
        return annotation -> JAVA_AND_QUARKUS_REST_ANNOTATIONS.contains(annotation.getNameAsString());
    }

    private Predicate<AnnotationExpr> isSwaggerAnnotation() {
        return annotation -> SPRING_BOOT_REST_ANNOTATIONS.contains(annotation.getNameAsString());
    }

    private KogitoWorkflowProcess parseProcess(String fileName) {
        Collection processes = ProcessCodegen.parseProcessFile((Resource)new FileSystemResource(new File(fileName)));
        Assertions.assertThat((Collection)processes).hasSize(1);
        Process process = (Process)processes.stream().findAny().orElseThrow();
        Assertions.assertThat((Object)process).isInstanceOf(KogitoWorkflowProcess.class);
        return (KogitoWorkflowProcess)process;
    }

    private KogitoBuildContext createContext(KogitoBuildContext.Builder contextBuilder) {
        AddonsConfig addonsConfig = AddonsConfig.builder().withMonitoring(false).withPrometheusMonitoring(false).build();
        return contextBuilder.withAddonsConfig(addonsConfig).build();
    }
}

