/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.persistence;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.data.GeneratedPOJO;
import org.kie.kogito.codegen.process.persistence.AbstractPersistenceGeneratorTest;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;
import org.kie.kogito.codegen.process.persistence.marshaller.MarshallerGenerator;
import org.kie.kogito.codegen.process.persistence.marshaller.ReflectionMarshallerGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ReflectionProtoGenerator;

class KafkaPersistenceGeneratorTest
extends AbstractPersistenceGeneratorTest {
    KafkaPersistenceGeneratorTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"persistenceTestContexts"})
    void test(KogitoBuildContext context) {
        context.setApplicationProperty("kogito.persistence.type", this.persistenceType());
        ReflectionProtoGenerator protoGenerator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().build(Collections.singleton(GeneratedPOJO.class));
        PersistenceGenerator persistenceGenerator = new PersistenceGenerator(context, (ProtoGenerator)protoGenerator, (MarshallerGenerator)new ReflectionMarshallerGenerator(context));
        Collection generatedFiles = persistenceGenerator.generate();
        if (context.hasDI()) {
            Optional<GeneratedFile> persistenceFactoryImpl = generatedFiles.stream().filter(gf -> gf.relativePath().equals("org/kie/kogito/persistence/KogitoProcessInstancesFactoryImpl.java")).findFirst();
            if (PersistenceGenerator.hasProtoMarshaller((KogitoBuildContext)context)) {
                List marshallerFiles = generatedFiles.stream().filter(gf -> gf.relativePath().endsWith("MessageMarshaller.java")).collect(Collectors.toList());
                String expectedMarshaller = "PersonMessageMarshaller";
                Assertions.assertThat(persistenceFactoryImpl).isNotEmpty();
                Assertions.assertThat((int)marshallerFiles.size()).isEqualTo(1);
                Assertions.assertThat((String)((GeneratedFile)marshallerFiles.get(0)).relativePath()).endsWith((CharSequence)(expectedMarshaller + ".java"));
            }
            CompilationUnit compilationUnit = StaticJavaParser.parse((InputStream)new ByteArrayInputStream(persistenceFactoryImpl.get().contents()));
            compilationUnit.findFirst(ClassOrInterfaceDeclaration.class).orElseThrow(() -> new NoSuchElementException("Compilation unit doesn't contain a class or interface declaration!"));
        }
    }

    @Override
    protected String persistenceType() {
        return "kafka";
    }
}

