/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.persistence;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.GeneratedFileType;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.data.GeneratedPOJO;
import org.kie.kogito.codegen.process.persistence.AbstractPersistenceGeneratorTest;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;
import org.kie.kogito.codegen.process.persistence.marshaller.MarshallerGenerator;
import org.kie.kogito.codegen.process.persistence.marshaller.ReflectionMarshallerGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ReflectionProtoGenerator;

class MongoDBPersistenceGeneratorTest
extends AbstractPersistenceGeneratorTest {
    private static final String PERSISTENCE_FILE_PATH = "org/kie/kogito/persistence/KogitoProcessInstancesFactoryImpl.java";
    private static final String TRANSACTION_FILE_PATH = "org/kie/kogito/mongodb/transaction/MongoDBTransactionManagerImpl.java";

    MongoDBPersistenceGeneratorTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"persistenceTestContexts"})
    void test(KogitoBuildContext context) {
        context.setApplicationProperty("kogito.persistence.type", this.persistenceType());
        ReflectionProtoGenerator protoGenerator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().build(Collections.singleton(GeneratedPOJO.class));
        PersistenceGenerator persistenceGenerator = new PersistenceGenerator(context, (ProtoGenerator)protoGenerator, (MarshallerGenerator)new ReflectionMarshallerGenerator(context));
        Collection generatedFiles = persistenceGenerator.generate();
        if (context.hasDI()) {
            Optional<GeneratedFile> generatedCLASSFile = generatedFiles.stream().filter(gf -> gf.category() == GeneratedFileType.SOURCE.category()).filter(f -> PERSISTENCE_FILE_PATH.equals(f.relativePath())).findAny();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)generatedCLASSFile.isPresent());
            GeneratedFile classFile = generatedCLASSFile.get();
            org.junit.jupiter.api.Assertions.assertEquals((Object)PERSISTENCE_FILE_PATH, (Object)classFile.relativePath());
            CompilationUnit compilationUnit = StaticJavaParser.parse((InputStream)new ByteArrayInputStream(classFile.contents()));
            ClassOrInterfaceDeclaration classDeclaration = (ClassOrInterfaceDeclaration)compilationUnit.findFirst(ClassOrInterfaceDeclaration.class).orElseThrow(() -> new NoSuchElementException("Compilation unit doesn't contain a class or interface declaration!"));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)classDeclaration);
            MethodDeclaration methodDeclaration = (MethodDeclaration)classDeclaration.findFirst(MethodDeclaration.class, d -> d.getName().getIdentifier().equals("dbName")).orElseThrow(() -> new NoSuchElementException("Class declaration doesn't contain a method named \"dbName\"!"));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)methodDeclaration);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)methodDeclaration.getBody().isPresent());
            BlockStmt body = (BlockStmt)methodDeclaration.getBody().get();
            Assertions.assertThat((int)body.getStatements().size()).isOne();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((Statement)body.getStatements().get(0)).isReturnStmt());
            ReturnStmt returnStmt = (ReturnStmt)body.getStatements().get(0);
            Assertions.assertThat((String)returnStmt.toString()).contains(new CharSequence[]{"kogito"});
            MethodDeclaration transactionMethodDeclaration = (MethodDeclaration)classDeclaration.findFirst(MethodDeclaration.class, d -> "transactionManager".equals(d.getName().getIdentifier())).orElseThrow(() -> new NoSuchElementException("Class declaration doesn't contain a method named \"transactionManager\"!"));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)transactionMethodDeclaration);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)transactionMethodDeclaration.getBody().isPresent());
            BlockStmt transactionMethodBody = (BlockStmt)transactionMethodDeclaration.getBody().get();
            Assertions.assertThat((int)transactionMethodBody.getStatements().size()).isOne();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((Statement)transactionMethodBody.getStatements().get(0)).isReturnStmt());
            ReturnStmt transactionReturnStmt = (ReturnStmt)transactionMethodBody.getStatements().get(0);
            Assertions.assertThat((String)transactionReturnStmt.toString()).contains(new CharSequence[]{"transactionManager"});
            Optional<GeneratedFile> generatedTransactionCLASSFile = generatedFiles.stream().filter(gf -> gf.category() == GeneratedFileType.SOURCE.category()).filter(f -> TRANSACTION_FILE_PATH.equals(f.relativePath())).findAny();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)generatedTransactionCLASSFile.isPresent());
            CompilationUnit transactionCompilationUnit = StaticJavaParser.parse((InputStream)new ByteArrayInputStream(generatedTransactionCLASSFile.get().contents()));
            ClassOrInterfaceDeclaration transactionClassDeclaration = (ClassOrInterfaceDeclaration)transactionCompilationUnit.findFirst(ClassOrInterfaceDeclaration.class).orElseThrow(() -> new NoSuchElementException("Compilation unit doesn't contain a class or interface declaration!"));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)transactionClassDeclaration);
            List constructorDeclarations = transactionCompilationUnit.findAll(ConstructorDeclaration.class);
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)constructorDeclarations.size());
            Optional<ConstructorDeclaration> annotatedConstructorDeclaration = constructorDeclarations.stream().filter(c -> c.isAnnotationPresent(this.injectionAnnotation(context))).findAny();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)annotatedConstructorDeclaration.isPresent());
            MethodDeclaration transactionEnabledMethodDeclaration = (MethodDeclaration)transactionClassDeclaration.findFirst(MethodDeclaration.class, d -> d.getName().getIdentifier().equals("enabled")).orElseThrow(() -> new NoSuchElementException("Class declaration doesn't contain a method named \"enabled\"!"));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)transactionEnabledMethodDeclaration);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)transactionEnabledMethodDeclaration.getBody().isPresent());
            BlockStmt enabledMethodBody = (BlockStmt)transactionEnabledMethodDeclaration.getBody().get();
            Assertions.assertThat((int)enabledMethodBody.getStatements().size()).isOne();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((Statement)enabledMethodBody.getStatements().get(0)).isReturnStmt());
            ReturnStmt enabledReturnStmt = (ReturnStmt)enabledMethodBody.getStatements().get(0);
            Assertions.assertThat((String)enabledReturnStmt.toString()).contains(new CharSequence[]{"enabled"});
            FieldDeclaration transactionEnabledFieldDeclaration = (FieldDeclaration)transactionClassDeclaration.findFirst(FieldDeclaration.class, f -> f.getVariable(0).getName().getIdentifier().equals("enabled")).orElseThrow(() -> new NoSuchElementException("Class declaration doesn't contain a field named \"enabled\"!"));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)transactionEnabledFieldDeclaration);
            AnnotationExpr transactionEnabledAnnotationDeclaration = (AnnotationExpr)transactionEnabledFieldDeclaration.findFirst(AnnotationExpr.class, a -> ((Name)a.getChildNodes().get(0)).getIdentifier().equals(this.configInjectionAnnotation(context))).orElseThrow(() -> new NoSuchElementException("Field declaration doesn't contain an annotation  named \"" + this.configInjectionAnnotation(context) + "\"!"));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)transactionEnabledAnnotationDeclaration);
            Assertions.assertThat((String)((Node)transactionEnabledAnnotationDeclaration.getChildNodes().get(1)).toString()).contains(new CharSequence[]{"kogito.persistence.transaction.enabled"});
        }
    }

    private String injectionAnnotation(KogitoBuildContext context) {
        switch (context.name()) {
            case "Quarkus": {
                return "Inject";
            }
            case "Spring": {
                return "Autowired";
            }
        }
        throw new RuntimeException("No injection annotation found");
    }

    private String configInjectionAnnotation(KogitoBuildContext context) {
        switch (context.name()) {
            case "Quarkus": {
                return "ConfigProperty";
            }
            case "Spring": {
                return "Value";
            }
        }
        throw new RuntimeException("No config injection annotation found");
    }

    @Override
    protected String persistenceType() {
        return "mongodb";
    }
}

