/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.persistence.marshaller;

import com.github.javaparser.ast.CompilationUnit;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.JavaKogitoBuildContext;
import org.kie.kogito.codegen.data.Answer;
import org.kie.kogito.codegen.data.AnswerWithAnnotations;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.codegen.data.PersonWithAddress;
import org.kie.kogito.codegen.data.PersonWithAddresses;
import org.kie.kogito.codegen.data.PersonWithList;
import org.kie.kogito.codegen.data.Question;
import org.kie.kogito.codegen.data.QuestionWithAnnotatedEnum;
import org.kie.kogito.codegen.process.persistence.marshaller.MarshallerGenerator;
import org.kie.kogito.codegen.process.persistence.proto.AbstractProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.Proto;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;

public abstract class AbstractMarshallerGeneratorTest<T> {
    KogitoBuildContext context = JavaKogitoBuildContext.builder().build();

    protected abstract MarshallerGenerator generator(KogitoBuildContext var1, Collection<T> var2);

    protected abstract ProtoGenerator.Builder<T, ? extends AbstractProtoGenerator<T>> protoGeneratorBuilder();

    protected abstract T convertToType(Class<?> var1);

    protected Collection<T> convertTypes(Class<?> ... classes) {
        return Arrays.stream(classes).map(c -> this.convertToType((Class<?>)c)).collect(Collectors.toList());
    }

    protected MarshallerGenerator withGenerator(Class<?> ... classes) {
        return this.generator(this.context, this.convertTypes(classes));
    }

    @Test
    void testPersonMarshallers() throws Exception {
        ProtoGenerator generator = this.protoGeneratorBuilder().withDataClasses(this.convertTypes(Person.class)).build(null);
        Proto proto = generator.protoOfDataClasses("org.kie.kogito.test", new String[]{"import \"kogito-types.proto\";"});
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        MarshallerGenerator marshallerGenerator = this.withGenerator(Person.class);
        List classes = marshallerGenerator.generate(proto.serialize());
        Assertions.assertThat((List)classes).isNotNull();
        Assertions.assertThat((List)classes).hasSize(1);
        Optional marshallerClass = ((CompilationUnit)classes.get(0)).getClassByName("PersonMessageMarshaller");
        Assertions.assertThat((Optional)marshallerClass).isPresent();
    }

    @Test
    void testPersonWithListMarshallers() throws Exception {
        ProtoGenerator generator = this.protoGeneratorBuilder().withDataClasses(this.convertTypes(PersonWithList.class)).build(null);
        Proto proto = generator.protoOfDataClasses("org.kie.kogito.test", new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        MarshallerGenerator marshallerGenerator = this.withGenerator(PersonWithList.class);
        List classes = marshallerGenerator.generate(proto.serialize());
        Assertions.assertThat((List)classes).isNotNull();
        Assertions.assertThat((List)classes).hasSize(1);
        Optional marshallerClass = ((CompilationUnit)classes.get(0)).getClassByName("PersonWithListMessageMarshaller");
        Assertions.assertThat((Optional)marshallerClass).isPresent();
    }

    @Test
    void testPersonWithAddressMarshallers() throws Exception {
        ProtoGenerator generator = this.protoGeneratorBuilder().withDataClasses(this.convertTypes(PersonWithAddress.class)).build(null);
        Proto proto = generator.protoOfDataClasses("org.kie.kogito.test", new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((List)proto.getMessages()).hasSize(2);
        MarshallerGenerator marshallerGenerator = this.withGenerator(PersonWithAddresses.class);
        List classes = marshallerGenerator.generate(proto.serialize());
        Assertions.assertThat((List)classes).isNotNull();
        Assertions.assertThat((List)classes).hasSize(2);
        Optional marshallerClass = ((CompilationUnit)classes.get(0)).getClassByName("AddressMessageMarshaller");
        Assertions.assertThat((Optional)marshallerClass).isPresent();
        marshallerClass = ((CompilationUnit)classes.get(1)).getClassByName("PersonWithAddressMessageMarshaller");
        Assertions.assertThat((Optional)marshallerClass).isPresent();
    }

    @Test
    void testPersonWithAddressesMarshallers() throws Exception {
        ProtoGenerator generator = this.protoGeneratorBuilder().withDataClasses(this.convertTypes(PersonWithAddresses.class)).build(null);
        Proto proto = generator.protoOfDataClasses("org.kie.kogito.test", new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((List)proto.getMessages()).hasSize(2);
        MarshallerGenerator marshallerGenerator = this.withGenerator(PersonWithAddresses.class);
        List classes = marshallerGenerator.generate(proto.serialize());
        Assertions.assertThat((List)classes).isNotNull();
        Assertions.assertThat((List)classes).hasSize(2);
        Optional marshallerClass = ((CompilationUnit)classes.get(0)).getClassByName("AddressMessageMarshaller");
        Assertions.assertThat((Optional)marshallerClass).isPresent();
        marshallerClass = ((CompilationUnit)classes.get(1)).getClassByName("PersonWithAddressesMessageMarshaller");
        Assertions.assertThat((Optional)marshallerClass).isPresent();
    }

    @Test
    void testEnumInPojosMarshallers() {
        Stream.of(Question.class, QuestionWithAnnotatedEnum.class).forEach(c -> {
            ProtoGenerator generator = this.protoGeneratorBuilder().withDataClasses(this.convertTypes((Class<?>)c)).build(null);
            Proto proto = generator.protoOfDataClasses("org.kie.kogito.test", new String[0]);
            Assertions.assertThat((Object)proto).isNotNull();
            Assertions.assertThat((List)proto.getMessages()).hasSize(1);
            MarshallerGenerator marshallerGenerator = this.withGenerator((Class<?>)c);
            List classes = null;
            try {
                classes = marshallerGenerator.generate(proto.serialize());
            }
            catch (IOException e) {
                Assertions.fail((String)("Error generating marshaller for " + c.getName()), (Throwable)e);
            }
            Assertions.assertThat((List)classes).isNotNull();
            Assertions.assertThat((List)classes).hasSize(2);
            Optional marshallerClass = ((CompilationUnit)classes.get(0)).getClassByName(c.getSimpleName() + "MessageMarshaller");
            Assertions.assertThat((Optional)marshallerClass).isPresent();
            String answerType = null;
            try {
                answerType = c.getDeclaredField("answer").getType().getSimpleName();
            }
            catch (NoSuchFieldException e) {
                Assertions.fail((String)("Unable to get answer field type for " + c.getName()), (Throwable)e);
            }
            marshallerClass = ((CompilationUnit)classes.get(1)).getClassByName(answerType + "EnumMarshaller");
            Assertions.assertThat((Optional)marshallerClass).isPresent();
        });
    }

    @Test
    void testEnumMarshallers() {
        Stream.of(Answer.class, AnswerWithAnnotations.class).forEach(e -> {
            ProtoGenerator generator = this.protoGeneratorBuilder().withDataClasses(this.convertTypes((Class<?>)e)).build(null);
            Proto proto = generator.protoOfDataClasses("org.kie.kogito.test", new String[0]);
            Assertions.assertThat((Object)proto).isNotNull();
            Assertions.assertThat((List)proto.getEnums()).hasSize(1);
            MarshallerGenerator marshallerGenerator = this.withGenerator((Class<?>)e);
            List classes = null;
            try {
                classes = marshallerGenerator.generate(proto.serialize());
            }
            catch (IOException ex) {
                Assertions.fail((String)("Error generating marshaller for " + e.getName()), (Object[])new Object[]{e});
            }
            Assertions.assertThat((List)classes).isNotNull();
            Assertions.assertThat((List)classes).hasSize(1);
            Optional marshallerClass = ((CompilationUnit)classes.get(0)).getClassByName(e.getSimpleName() + "EnumMarshaller");
            Assertions.assertThat((Optional)marshallerClass).isPresent();
        });
    }
}

