/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.persistence.proto;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.process.persistence.proto.Proto;
import org.kie.kogito.codegen.process.persistence.proto.ReflectionProtoGenerator;

class AbstractProtoGeneratorTest {
    AbstractProtoGeneratorTest() {
    }

    @Test
    void checkGeneratedProtoBufAndListing() throws IOException {
        ReflectionProtoGenerator generator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().build(null);
        ArrayList<GeneratedFile> generatedFiles = new ArrayList<GeneratedFile>();
        for (int i = 0; i < 5; ++i) {
            Proto proto = new Proto("org.acme.test", new String[0]);
            generatedFiles.add(generator.generateProtoFiles("protofile." + i, proto));
        }
        generator.generateProtoListingFile(generatedFiles).ifPresent(generatedFiles::add);
        GeneratedFile listFile = generatedFiles.stream().filter(x -> x.relativePath().endsWith("list.json")).findFirst().get();
        byte[] list = listFile.contents();
        ObjectMapper mapper = new ObjectMapper();
        List files = (List)mapper.readValue(list, List.class);
        Assertions.assertThat((List)files).isNotEmpty();
        ((ListAssert)Assertions.assertThat((List)files).hasAtLeastOneElementOfType(String.class)).contains((Object[])new String[]{"protofile.0.proto"}).hasSize(5);
    }
}

