/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.persistence.proto;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.data.Address;
import org.kie.kogito.codegen.data.Answer;
import org.kie.kogito.codegen.data.AnswerWitAnnotations;
import org.kie.kogito.codegen.data.GeneratedPOJO;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.codegen.data.PersonVarInfo;
import org.kie.kogito.codegen.data.PersonWithAddress;
import org.kie.kogito.codegen.data.PersonWithAddresses;
import org.kie.kogito.codegen.data.PersonWithList;
import org.kie.kogito.codegen.data.Question;
import org.kie.kogito.codegen.data.QuestionWithAnnotatedEnum;
import org.kie.kogito.codegen.process.persistence.proto.Proto;
import org.kie.kogito.codegen.process.persistence.proto.ProtoEnum;
import org.kie.kogito.codegen.process.persistence.proto.ProtoField;
import org.kie.kogito.codegen.process.persistence.proto.ProtoMessage;
import org.kie.kogito.codegen.process.persistence.proto.ReflectionProtoGenerator;

class ReflectionProtoGeneratorTest {
    ReflectionProtoGeneratorTest() {
    }

    @Test
    void testPersonProtoFile() {
        ReflectionProtoGenerator generator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().withDataClasses(Collections.singleton(Person.class)).build(null);
        Proto proto = generator.protoOfDataClasses("org.kie.kogito.test", new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        ProtoMessage person = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getName()).isEqualTo("Person");
        Assertions.assertThat((String)person.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)person.getFields()).hasSize(3);
        ProtoField field = (ProtoField)person.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("adult");
        Assertions.assertThat((String)field.getType()).isEqualTo("bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("age");
        Assertions.assertThat((String)field.getType()).isEqualTo("int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("name");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
    }

    @Test
    void testPersonWithAddressProtoFile() {
        ReflectionProtoGenerator generator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().withDataClasses(Collections.singleton(PersonWithAddress.class)).build(null);
        Proto proto = generator.protoOfDataClasses("org.kie.kogito.test", new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(2);
        ProtoMessage address = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)address).isNotNull();
        Assertions.assertThat((String)address.getName()).isEqualTo("Address");
        Assertions.assertThat((String)address.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)address.getFields()).hasSize(4);
        ProtoField field = (ProtoField)address.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("city");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("country");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("street");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(3);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("zipCode");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        ProtoMessage person = (ProtoMessage)proto.getMessages().get(1);
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getName()).isEqualTo("PersonWithAddress");
        Assertions.assertThat((String)person.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)person.getFields()).hasSize(4);
        field = (ProtoField)person.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("address");
        Assertions.assertThat((String)field.getType()).isEqualTo("Address");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("adult");
        Assertions.assertThat((String)field.getType()).isEqualTo("bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("age");
        Assertions.assertThat((String)field.getType()).isEqualTo("int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(3);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("name");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
    }

    @Test
    void testPersonWithListProtoFile() {
        ReflectionProtoGenerator generator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().withDataClasses(Collections.singleton(PersonWithList.class)).build(null);
        Proto proto = generator.protoOfDataClasses("org.kie.kogito.test", new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        ProtoMessage address = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)address).isNotNull();
        Assertions.assertThat((String)address.getName()).isEqualTo("PersonWithList");
        Assertions.assertThat((String)address.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)address.getFields()).hasSize(7);
        ProtoField field = (ProtoField)address.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("adult");
        Assertions.assertThat((String)field.getType()).isEqualTo("bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("age");
        Assertions.assertThat((String)field.getType()).isEqualTo("int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("booleanList");
        Assertions.assertThat((String)field.getType()).isEqualTo("bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("repeated");
        field = (ProtoField)address.getFields().get(3);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("integerList");
        Assertions.assertThat((String)field.getType()).isEqualTo("int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("repeated");
        field = (ProtoField)address.getFields().get(4);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("longList");
        Assertions.assertThat((String)field.getType()).isEqualTo("int64");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("repeated");
        field = (ProtoField)address.getFields().get(5);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("name");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(6);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("stringList");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("repeated");
    }

    @Test
    void testPersonWithAddressesProtoFile() {
        ReflectionProtoGenerator generator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().withDataClasses(Collections.singleton(PersonWithAddresses.class)).build(null);
        Proto proto = generator.protoOfDataClasses("org.kie.kogito.test", new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(2);
        ProtoMessage address = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)address).isNotNull();
        Assertions.assertThat((String)address.getName()).isEqualTo("Address");
        Assertions.assertThat((String)address.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)address.getFields()).hasSize(4);
        ProtoField field = (ProtoField)address.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("city");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("country");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("street");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)address.getFields().get(3);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("zipCode");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        ProtoMessage person = (ProtoMessage)proto.getMessages().get(1);
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getName()).isEqualTo("PersonWithAddresses");
        Assertions.assertThat((String)person.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)person.getFields()).hasSize(4);
        field = (ProtoField)person.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("addresses");
        Assertions.assertThat((String)field.getType()).isEqualTo("Address");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("repeated");
        field = (ProtoField)person.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("adult");
        Assertions.assertThat((String)field.getType()).isEqualTo("bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("age");
        Assertions.assertThat((String)field.getType()).isEqualTo("int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)person.getFields().get(3);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("name");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
    }

    @Test
    void testPersonAsModelProtoFile() {
        ReflectionProtoGenerator generator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().build(Collections.emptyList());
        Proto proto = generator.generate("@Indexed", "@Field(store = Store.YES) @SortableField", "org.kie.kogito.test.persons", Person.class, new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test.persons");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        ProtoMessage person = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getName()).isEqualTo("Person");
        Assertions.assertThat((String)person.getComment()).isEqualTo("@Indexed");
        Assertions.assertThat((String)person.getJavaPackageOption()).isEqualTo("org.kie.kogito.test.persons");
        Assertions.assertThat((List)person.getFields()).hasSize(3);
        ProtoField field = (ProtoField)person.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("adult");
        Assertions.assertThat((String)field.getType()).isEqualTo("bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(store = Store.YES) @SortableField");
        field = (ProtoField)person.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("age");
        Assertions.assertThat((String)field.getType()).isEqualTo("int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(store = Store.YES) @SortableField");
        field = (ProtoField)person.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("name");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(store = Store.YES) @SortableField");
    }

    @Test
    void testPersonWithVariableInfoAsModelProtoFile() {
        ReflectionProtoGenerator generator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().build(Collections.emptyList());
        Proto proto = generator.generate("@Indexed", "@Field(store = Store.YES) @SortableField", "org.kie.kogito.test.persons", PersonVarInfo.class, new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test.persons");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        ProtoMessage person = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getName()).isEqualTo("PersonVarInfo");
        Assertions.assertThat((String)person.getComment()).isEqualTo("@Indexed");
        Assertions.assertThat((String)person.getJavaPackageOption()).isEqualTo("org.kie.kogito.test.persons");
        Assertions.assertThat((List)person.getFields()).hasSize(3);
        ProtoField field = (ProtoField)person.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("adult");
        Assertions.assertThat((String)field.getType()).isEqualTo("bool");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(store = Store.YES) @SortableField");
        field = (ProtoField)person.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("age");
        Assertions.assertThat((String)field.getType()).isEqualTo("int32");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(store = Store.YES) @SortableField");
        field = (ProtoField)person.getFields().get(2);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("name");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        Assertions.assertThat((String)field.getComment()).isEqualTo("@Field(store = Store.YES) @SortableField\n @VariableInfo(tags=\"test\")");
    }

    @Test
    void testAnswerProtoFile() {
        ReflectionProtoGenerator generator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().withDataClasses(Collections.singleton(Answer.class)).build(null);
        Proto proto = generator.protoOfDataClasses("org.kie.kogito.test.persons", new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test.persons");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getEnums()).hasSize(1);
        ProtoEnum answer = (ProtoEnum)proto.getEnums().get(0);
        Assertions.assertThat((Object)answer).isNotNull();
        Assertions.assertThat((String)answer.getName()).isEqualTo("Answer");
        Assertions.assertThat((String)answer.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((Map)answer.getFields()).hasSize(3);
        Map fields = answer.getFields();
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)fields).isNotNull()).containsEntry((Object)"YES", (Object)0)).containsEntry((Object)"MAYBE", (Object)1)).containsEntry((Object)"NO", (Object)2);
    }

    @Test
    void testAnswerWithAnnotationsProtoFile() {
        ReflectionProtoGenerator generator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().withDataClasses(Collections.singleton(AnswerWitAnnotations.class)).build(null);
        Proto proto = generator.protoOfDataClasses("org.kie.kogito.test.persons", new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test.persons");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getEnums()).hasSize(1);
        ProtoEnum answer = (ProtoEnum)proto.getEnums().get(0);
        Assertions.assertThat((Object)answer).isNotNull();
        Assertions.assertThat((String)answer.getName()).isEqualTo("AnswerWitAnnotations");
        Assertions.assertThat((String)answer.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((Map)answer.getFields()).hasSize(3);
        Map fields = answer.getFields();
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)fields).isNotNull()).containsEntry((Object)"YES", (Object)1)).containsEntry((Object)"MAYBE", (Object)2)).containsEntry((Object)"NO", (Object)3);
    }

    @Test
    void testAnswerWithVariableInfoProtoFile() {
        ReflectionProtoGenerator generator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().withDataClasses(Collections.emptyList()).build(null);
        Proto proto = generator.generate("@Indexed", "@Field(store = Store.YES) @SortableField", "org.kie.kogito.test.persons", Answer.class, new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test.persons");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getEnums()).hasSize(1);
        ProtoEnum answer = (ProtoEnum)proto.getEnums().get(0);
        Assertions.assertThat((Object)answer).isNotNull();
        Assertions.assertThat((String)answer.getName()).isEqualTo("Answer");
        Assertions.assertThat((String)answer.getComment()).isBlank();
        Assertions.assertThat((String)answer.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((Map)answer.getFields()).hasSize(3);
        Map fields = answer.getFields();
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)fields).isNotNull()).containsEntry((Object)"YES", (Object)0)).containsEntry((Object)"MAYBE", (Object)1)).containsEntry((Object)"NO", (Object)2);
    }

    @Test
    void testQuestionWithEnumProtoFile() {
        ReflectionProtoGenerator generator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().withDataClasses(Collections.singleton(Question.class)).build(null);
        Proto proto = generator.protoOfDataClasses("org.kie.kogito.test.persons", new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test.persons");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        ProtoMessage question = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)question).isNotNull();
        Assertions.assertThat((String)question.getName()).isEqualTo("Question");
        Assertions.assertThat((String)question.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)question.getFields()).hasSize(2);
        ProtoField field = (ProtoField)question.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("answer");
        Assertions.assertThat((String)field.getType()).isEqualTo("Answer");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)question.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("question");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
    }

    @Test
    void testQuestionWithAnnotatedEnumProtoFile() {
        ReflectionProtoGenerator generator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().withDataClasses(Collections.singleton(QuestionWithAnnotatedEnum.class)).build(null);
        Proto proto = generator.protoOfDataClasses("org.kie.kogito.test.persons", new String[0]);
        Assertions.assertThat((Object)proto).isNotNull();
        Assertions.assertThat((String)proto.getPackageName()).isEqualTo("org.kie.kogito.test.persons");
        Assertions.assertThat((String)proto.getSyntax()).isEqualTo("proto2");
        Assertions.assertThat((List)proto.getMessages()).hasSize(1);
        ProtoMessage question = (ProtoMessage)proto.getMessages().get(0);
        Assertions.assertThat((Object)question).isNotNull();
        Assertions.assertThat((String)question.getName()).isEqualTo("QuestionWithAnnotatedEnum");
        Assertions.assertThat((String)question.getJavaPackageOption()).isEqualTo("org.kie.kogito.codegen.data");
        Assertions.assertThat((List)question.getFields()).hasSize(2);
        ProtoField field = (ProtoField)question.getFields().get(0);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("answer");
        Assertions.assertThat((String)field.getType()).isEqualTo("AnswerWitAnnotations");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
        field = (ProtoField)question.getFields().get(1);
        Assertions.assertThat((Object)field).isNotNull();
        Assertions.assertThat((String)field.getName()).isEqualTo("question");
        Assertions.assertThat((String)field.getType()).isEqualTo("string");
        Assertions.assertThat((String)field.getApplicability()).isEqualTo("optional");
    }

    @Test
    void builderTest() {
        ReflectionProtoGenerator emptyGenerator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().build(null);
        Assertions.assertThat((Class)((Class)emptyGenerator.getPersistenceClass())).isNull();
        ((IterableAssert)Assertions.assertThat((Iterable)emptyGenerator.getDataClasses()).isNotNull()).isEmpty();
        ((IterableAssert)Assertions.assertThat((Iterable)emptyGenerator.getModelClasses()).isNotNull()).isEmpty();
        ReflectionProtoGenerator persistenceClassGenerator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().withPersistenceClass(Person.class).build(null);
        Assertions.assertThat((Class)((Class)persistenceClassGenerator.getPersistenceClass())).isEqualTo(Person.class);
        ((IterableAssert)Assertions.assertThat((Iterable)persistenceClassGenerator.getDataClasses()).isNotNull()).isEmpty();
        ((IterableAssert)Assertions.assertThat((Iterable)persistenceClassGenerator.getModelClasses()).isNotNull()).isEmpty();
        ReflectionProtoGenerator dataClassGenerator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().withDataClasses(Collections.singleton(Person.class)).build(null);
        Assertions.assertThat((Class)((Class)dataClassGenerator.getPersistenceClass())).isNull();
        ((IterableAssert)Assertions.assertThat((Iterable)dataClassGenerator.getDataClasses()).isNotNull()).hasSize(1);
        ((IterableAssert)Assertions.assertThat((Iterable)dataClassGenerator.getModelClasses()).isNotNull()).isEmpty();
        ReflectionProtoGenerator modelClassGenerator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().build(Collections.singleton(GeneratedPOJO.class));
        Assertions.assertThat((Class)((Class)modelClassGenerator.getPersistenceClass())).isNull();
        ((IterableAssert)Assertions.assertThat((Iterable)modelClassGenerator.getDataClasses()).isNotNull()).hasSize(1);
        ((IterableAssert)Assertions.assertThat((Iterable)modelClassGenerator.getModelClasses()).isNotNull()).hasSize(1);
        ReflectionProtoGenerator dataClassAndModelClassGenerator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().withDataClasses(Arrays.asList(Person.class, Address.class)).build(Collections.singleton(GeneratedPOJO.class));
        Assertions.assertThat((Class)((Class)dataClassAndModelClassGenerator.getPersistenceClass())).isNull();
        ((IterableAssert)Assertions.assertThat((Iterable)dataClassAndModelClassGenerator.getDataClasses()).isNotNull()).hasSize(2);
        ((IterableAssert)Assertions.assertThat((Iterable)dataClassAndModelClassGenerator.getModelClasses()).isNotNull()).hasSize(1);
    }

    @Test
    void persistenceClassParams() {
        ReflectionProtoGenerator noPersistenceClassGenerator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().withPersistenceClass(null).build(null);
        Assertions.assertThat((Iterable)noPersistenceClassGenerator.getPersistenceClassParams()).isEmpty();
        ReflectionProtoGenerator emptyGenerator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().withPersistenceClass(EmptyConstructor.class).build(null);
        Assertions.assertThat((Iterable)emptyGenerator.getPersistenceClassParams()).isEmpty();
        ReflectionProtoGenerator notEmptyGenerator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().withPersistenceClass(NotEmptyConstructor.class).build(null);
        ((IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)notEmptyGenerator.getPersistenceClassParams()).isNotEmpty()).hasSize(2)).isEqualTo(Arrays.asList(String.class.getCanonicalName(), Integer.TYPE.getCanonicalName()));
    }

    private static class NotEmptyConstructor {
        public NotEmptyConstructor(String param1, int param2) {
        }
    }

    private static class EmptyConstructor {
    }
}

