/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.events;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.core.io.CollectedResourceProducer;
import org.kie.kogito.codegen.process.ProcessCodegen;

public class CodegenMessageStartEventTest {
    private static final Path BASE_PATH = Paths.get("src/test/resources/", new String[0]).toAbsolutePath();
    private static final String MESSAGE_START_EVENT_SOURCE = "messagestartevent/MessageStartEvent.bpmn2";
    private static final Path MESSAGE_START_EVENT_SOURCE_FULL_SOURCE = BASE_PATH.resolve("messagestartevent/MessageStartEvent.bpmn2");
    private static final String MESSAGE_END_EVENT_SOURCE = "messagestartevent/MessageEndEvent.bpmn2";
    private static final Path MESSAGE_END_EVENT_SOURCE_FULL_SOURCE = BASE_PATH.resolve("messagestartevent/MessageEndEvent.bpmn2");
    private static final String MESSAGE_START_END_EVENT_SOURCE = "messagestartevent/MessageStartAndEndEvent.bpmn2";
    private static final Path MESSAGE_START_END_EVENT_SOURCE_FULL_SOURCE = BASE_PATH.resolve("messagestartevent/MessageStartAndEndEvent.bpmn2");

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void testRESTApiForMessageStartEvent(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.build();
        ProcessCodegen codeGenerator = ProcessCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResourceProducer.fromFiles((Path)BASE_PATH, (File[])new File[]{MESSAGE_START_EVENT_SOURCE_FULL_SOURCE.toFile()}));
        Collection generatedFiles = codeGenerator.generate();
        Assertions.assertThat((Iterable)generatedFiles).isNotEmpty();
        List resources = generatedFiles.stream().filter(generatedFile -> generatedFile.relativePath().endsWith("org/kie/kogito/test/MessageStartEventResource.java")).collect(Collectors.toList());
        if (context.hasREST()) {
            Assertions.assertThat((int)resources.size()).isEqualTo(1);
            CompilationUnit parsedResource = StaticJavaParser.parse((String)new String(((GeneratedFile)resources.get(0)).contents()));
            ((OptionalAssert)Assertions.assertThat((Optional)parsedResource.findFirst(MethodDeclaration.class, md -> md.getNameAsString().startsWith("createResource"))).withFailMessage("For processes without none start event there should not be create resource method", new Object[0])).isEmpty();
        } else {
            Assertions.assertThat((int)resources.size()).isZero();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void testRESTApiForMessageEndEvent(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.build();
        ProcessCodegen codeGenerator = ProcessCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResourceProducer.fromFiles((Path)BASE_PATH, (File[])new File[]{MESSAGE_END_EVENT_SOURCE_FULL_SOURCE.toFile()}));
        Collection generatedFiles = codeGenerator.generate();
        Assertions.assertThat((Iterable)generatedFiles).isNotEmpty();
        List resources = generatedFiles.stream().filter(generatedFile -> generatedFile.relativePath().endsWith("org/kie/kogito/test/MessageStartEventResource.java")).collect(Collectors.toList());
        if (context.hasREST()) {
            Assertions.assertThat((int)resources.size()).isEqualTo(1);
            CompilationUnit parsedResource = StaticJavaParser.parse((String)new String(((GeneratedFile)resources.get(0)).contents()));
            ((ListAssert)Assertions.assertThat((List)parsedResource.findAll(MethodDeclaration.class, md -> md.getNameAsString().startsWith("createResource"))).withFailMessage("Must have method with name 'createResource'", new Object[0])).hasSize(1);
        } else {
            Assertions.assertThat((int)resources.size()).isZero();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void testMessageProducerForMessageEndEvent(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.build();
        ProcessCodegen codeGenerator = ProcessCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResourceProducer.fromFiles((Path)BASE_PATH, (File[])new File[]{MESSAGE_START_END_EVENT_SOURCE_FULL_SOURCE.toFile()}));
        Collection generatedFiles = codeGenerator.generate();
        Assertions.assertThat((Iterable)generatedFiles).isNotEmpty();
        List resources = generatedFiles.stream().filter(generatedFile -> generatedFile.relativePath().endsWith("org/kie/kogito/test/MessageStartEventMessageProducer_3.java")).collect(Collectors.toList());
        Assertions.assertThat((int)resources.size()).isEqualTo(1);
        CompilationUnit parsedResource = StaticJavaParser.parse((String)new String(((GeneratedFile)resources.get(0)).contents()));
        if (context.hasDI()) {
            ((ListAssert)Assertions.assertThat((List)parsedResource.findAll(ClassOrInterfaceDeclaration.class, cd -> cd.getExtendedTypes().stream().anyMatch(et -> et.getNameAsString().endsWith("AbstractMessageProducer")))).withFailMessage("Must extends class 'AbstractMessageProducer'", new Object[0])).hasSize(1);
        } else {
            ((ListAssert)Assertions.assertThat((List)parsedResource.findAll(MethodDeclaration.class, md -> md.getNameAsString().equals("produce"))).withFailMessage("Must have method with name 'produce'", new Object[0])).hasSize(1);
        }
    }
}

