/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.events;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.core.io.CollectedResourceProducer;
import org.kie.kogito.codegen.process.ProcessCodegen;

public class CodegenUserTaskTest {
    private static final Path BASE_PATH = Paths.get("src/test/resources/", new String[0]).toAbsolutePath();
    private static final String MESSAGE_USERTASK_SOURCE = "usertask/UserTasksProcess.bpmn2";
    private static final Path MESSAGE_USERTASK_SOURCE_FULL_SOURCE = BASE_PATH.resolve("usertask/UserTasksProcess.bpmn2");

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void testRESTApiForMessageStartEvent(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.build();
        ProcessCodegen codeGenerator = ProcessCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResourceProducer.fromFiles((Path)BASE_PATH, (File[])new File[]{MESSAGE_USERTASK_SOURCE_FULL_SOURCE.toFile()}));
        Collection generatedFiles = codeGenerator.generate();
        Assertions.assertThat((Iterable)generatedFiles).isNotEmpty();
        List resources = generatedFiles.stream().filter(generatedFile -> generatedFile.relativePath().endsWith("org/kie/kogito/test/UserTasksProcessResource.java")).collect(Collectors.toList());
        if (context.hasREST()) {
            Assertions.assertThat((int)resources.size()).isEqualTo(1);
            CompilationUnit parsedResource = StaticJavaParser.parse((String)new String(((GeneratedFile)resources.get(0)).contents()));
            List completeTaskMethods = parsedResource.findAll(MethodDeclaration.class, md -> md.getNameAsString().startsWith("completeTask"));
            Assertions.assertThat((List)completeTaskMethods).hasSize(2);
            completeTaskMethods.forEach(completeTaskMethod -> Assertions.assertThat((Boolean)context.getRestAnnotator().getEndpointValue((NodeWithAnnotations)completeTaskMethod).map(url -> url.contains("/{id}/FirstTask/{taskId}") || url.contains("/{id}/SecondTask/{taskId}")).orElse(true)).isTrue());
        } else {
            Assertions.assertThat((int)resources.size()).isZero();
        }
    }
}

